/*
 *  Arnold emulator (c) Copyright, Kevin Thacker 1995-2001
 *
 *  This file is part of the Arnold emulator source code distribution.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 */

//Heap Corruption
// _CrtCheckMemory()
//http://msdn.microsoft.com/en-us/library/aa246729%28v=vs.60%29.aspx


//#define WIN32_LEAN_AND_MEAN
#define STRICT
#define AUDIO

#define DIRECTINPUT_VERSION 0x0300


//#ifdef _DEBUG
/* for CRT debugging functions (memory leak checking etc) */
//#define _CRTDBG_MAP_ALLOC
//#include <stdlib.h>
//#include <crtdbg.h>
//#endif

#include "precomp.h"

//for Visual Leak Detector
//#include <vld.h>


#include <stdio.h>
#include <stdlib.h>
#include <io.h>
#include <windows.h>
#include <dinput.h>
#include <shellapi.h>	/* for drag and drop */

#include <tchar.h>	/* for ANSI/UNICODE text functions */
#include <commctrl.h>	/* for Windows' common controls */
#include <ctype.h>

#include "cmdline.h"	/* for converting command-line string into argc, argv style */
#include "cpcemu.h"
#include "mylistvw.h"
#include "scrsnap.h"
//#include "joy.h"
#include "filetool.h"
#include "OnScreenDisplay.h"
#include "filedlg.h"
#include "reg.h"
#include "mylistvw.h"
#include "cassdlg.h"
#include "romcfg.h"
#include "chtdb.h"

#include "ifacegen.h"
#include "comboh.h"	/* combo box helper macros */
#include "resource.h"	/* resource data */
#include "InterfaceLoadSave.h"

#include "directx/graphlib.h"
#include "directx\MyDI.h"
#include "directx\ds.h"
#include "directx\dd.h"
#include "directx\di.h"
#include "Specific.h"
#include "joy.h"

#include "../../cpc/wav.h"
#include "../../cpc/audio.h"
#include "../../cpc/cpc.h"
#include "../../cpc_modified/cheatdb.h"
#include "../../cpc/tzx.h"
#include "../../cpc/ramrom.h"
#include "../../special/win/messages.h"
#include "../../cpc/diskimage/diskimg.h"
#include "../../cpc/autotype.h"	/* for Auto-Type and Auto-Run */
#include "../../cpc/amsdos.h"	/* for Auto-Run */
#include "../../cpc/autorunfile.h"
#include "../../cpc/snapshot.h"
#include "../../cpc/render.h"
#include "../../cpc_modified/arnold.h"
#include "../../cpc/asic.h"
#include "../../cpc/fdd.h"
#include "../../cpc/cassette.h"
#include "../../cpc/fdd.h"
#include "../../cpc/joystick.h"
#include "../../cpc/emudevice.h"
#include "../../cpc/pal.h"
#include "../../cpc/ddi.h"
#include "../../cpc/monitor.h"


#include "../zipsupport/UnzipApp.h"


/*********************************************************/

int DkTronics256KBRam_Init(void);

int PALDeviceIndex = -1;
int DkTronics256KB = -1;
int dDigiblaster = -1;

extern BOOL Parados_enabled;
/*----------------------------------------------------------------------------------*/

int timer_id = 0;


static TCHAR FilenameBuffer[MAX_PATH];
static char AutoType_String[256];

void Z80_WR_MEM(const Z80_WORD addr, const Z80_BYTE val);
void Interface_RAMROM_Dialog(HWND hwnd);
int DigiblasterDevice_Init();
/*----------------------------------------------------------------------------------*/

/* class name for creation of windows etc */
#define APP_CLASS_NAME "ArnoldEmu"

/* name of app as reported in dialogs */
#define APP_TITLE_TEXT	"Arnold Emulator"

/* name of app for DDE */
#define APP_NAME	"Arnold"

/* release/version of Arnold as seen by Joe Public */
const TCHAR *sVersion=_T("04/01/2004");

APP_DATA AppData;


extern SNAPSHOT_OPTIONS Options;
/*----------------------------------------------------------------------------------------------*/

BOOL	CPCEMU_DetectFileAndLoad(const TCHAR *pFilename);
void	CPCEMU_ProcessCommandLineBefore(LPCTSTR sCommandLine);
void	CPCEMU_ProcessCommandLineAfter(LPCTSTR sCommandLine);
void    Interface_LoadFile(HWND);

/*----------------------------------------------------------------------------------------------*/
#if 0
void	Interface_LoadMultifaceROM(const MULTIFACE_ROM_TYPE RomType, const TCHAR *sFilename)
{
	unsigned char *pRomData;
	unsigned long RomSize;

	/* try to load it */
	LoadFile(sFilename, &pRomData, &RomSize);

	if (pRomData!=NULL)
	{
		Multiface_SetRomData(RomType, pRomData, RomSize);

		free(pRomData);
	}
}
#endif
/*----------------------------------------------------------------------------------------------*/
BOOL Interface_InsertDiskFromFile(int nDriveID, const TCHAR *sFilename)
{
	unsigned char *pLocation;
	unsigned long Length;
	char tmp[MAX_PATH];

	LoadFile(sFilename, &pLocation, &Length);

	if (pLocation == NULL)
	{
		SetInfoMessage("Sorry - Wrong path");
		return FALSE;
	}

	if (DiskImage_InsertDisk(nDriveID, pLocation, Length)!=ARNOLD_STATUS_OK)
	{
		SetInfoMessage("Sorry - Loading failed");
	}
	else
	{
		wsprintf(tmp,"loading Disk : %s",sFilename);
		SetInfoMessage(tmp);
	}
	
	free(pLocation);

	/* add to recent */
	RecentFiles_AddAndRefresh(AppData.ApplicationHwnd, sFilename, RECENT_LIST_FILES);

	//memorise it
	if (nDriveID == 0) strcpy(DriveAFilename,sFilename);
	else strcpy(DriveBFilename,sFilename);
	strcpy(LastOpenedRom,sFilename);

	return TRUE;
}
/*----------------------------------------------------------------------------------------------*/
BOOL Interface_InsertRomFromFile(const int RomIndex,const TCHAR *pFilename)
{
	unsigned char *pRomData;
	unsigned long RomDataSize;

	LoadFile(pFilename, &pRomData, &RomDataSize);
	if (pRomData!=NULL)
	{
		//ExpansionRom_SetRomData(pRomData, RomDataSize, RomIndex);

		free(pRomData);

		return TRUE;
	}

	return FALSE;
}

/*----------------------------------------------------------------------------------------------*/
typedef struct
{
	unsigned char *pData;		/* pointer to binary data */
	unsigned long nLength;		/* length of binary data */
} BINARY_DATA_BLOCK;

/* built in data */
static BINARY_DATA_BLOCK	CPCPLUS_SystemCartridge_ENG;
static BINARY_DATA_BLOCK	CPC464_OperatingSystemRom_ENG;
static BINARY_DATA_BLOCK	CPC464_BASICRom_ENG;
static BINARY_DATA_BLOCK	CPC664_OperatingSystemRom_ENG;
static BINARY_DATA_BLOCK	CPC664_BASICRom_ENG;
static BINARY_DATA_BLOCK	CPC6128_OperatingSystemRom_ENG;
static BINARY_DATA_BLOCK	CPC6128_BASICRom_ENG;
static BINARY_DATA_BLOCK	KCC_OperatingSystemRom_ENG;
static BINARY_DATA_BLOCK	KCC_BASICRom_ENG;
static BINARY_DATA_BLOCK	AMSDOSRom_ENG;
static BINARY_DATA_BLOCK	PARADOS_ENG;


#ifdef _UNICODE

#include <winnls.h>
/*----------------------------------------------------------------------------------------------*/
LPCSTR ConvertUnicodeStringToMultiByte(const TCHAR *sUnicodeString)
{
	LPSTR MultiByteString = NULL;

	int nBytes;

	/* get number of bytes required for converted string */
	nBytes = WideCharToMultiByte(CP_ACP,0,sUnicodeString,_tcslen(sUnicodeString), NULL,0, NULL, NULL);

	if (nBytes!=0)
	{
		/* allocate space for converted string */
		MultiByteString = malloc(nBytes);

		if (MultiByteString)
		{
			/* do the conversion */
			WideCharToMultiByte(CP_ACP, 0,sUnicodeString, _tcslen(sUnicodeString), MultiByteString, nBytes, NULL, NULL);
		}
	}

	/* return converted string or NULL if there was an error */
	return (LPCSTR)MultiByteString;
}

/*----------------------------------------------------------------------------------------------*/
const TCHAR *ConvertMultiByteToUnicode(LPCSTR sMultiByte)
{
	TCHAR *sUnicodeString = NULL;
	int nChars;

	nChars = MultiByteToWideChar(CP_ACP,MB_PRECOMPOSED,sMultiByte,strlen(sMultiByte),NULL,0);

	if (nChars!=0)
	{
		/* allocate space for converted string */
		sUnicodeString = malloc(nChars*sizeof(TCHAR));

		if (sUnicodeString)
		{
			MultiByteToWideChar(CP_ACP,MB_PRECOMPOSED,sMultiByte,strlen(sMultiByte),sUnicodeString,nChars);
		}
	}

	return sUnicodeString;
}
#endif
/*----------------------------------------------------------------------------------------------*/
static void GenerateTempFilename(TCHAR *TempFilename)
{
	TCHAR TempPath[MAX_PATH];

	/* get temp path */
	GetTempPath(MAX_PATH,TempPath);
	/* generate full temp filename */
	GetTempFileName(TempPath, _T("ARN"),0,TempFilename);
}

/*----------------------------------------------------------------------------------------------*/

static void GetDataFromCustomResource(HMODULE hModule, unsigned char **ppPtr, unsigned long *pLength, LPTSTR sResource)
{
	/* find our custom resource by the id of the resource and get a handle to it's info block */
	HRSRC hResource = FindResource(hModule,(LPCTSTR)sResource,RT_RCDATA);

	if (hResource!=NULL)
	{
		/* load the resource into global memory; and get the handle to the memory */
		HGLOBAL hResourceMemory = LoadResource(hModule, hResource);

		if (ppPtr!=NULL)
		{
			/* lock the resource to get a pointer to the data in memory */
			LPVOID pResourceData = LockResource(hResourceMemory);

			*ppPtr = (unsigned char *)pResourceData;
		}

		if (pLength!=NULL)
		{
			/* get size of the resource; most functions in the main core require a size to work with */
			DWORD nResourceSize = SizeofResource(hModule, hResource);

			*pLength = nResourceSize;
		}
	}
}

/*----------------------------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------------------------*/

void CPCEMU_HandleDragDrop(HDROP DropHandle)
{
	if (DropHandle!=0)
	{
		unsigned int i;

		/* get number of files dropped */
		unsigned int NoOfFilesDropped = DragQueryFile(DropHandle, 0xFFFFFFFF, NULL, 0);

		if (NoOfFilesDropped!=0)
		{
			int MaxFilenameSize;
			TCHAR *pFilenameBuffer;

			MaxFilenameSize = 0;

			/* get size of largest filename */
			for (i=0; i!=NoOfFilesDropped; i++)
			{
				int FilenameSize;

				/* get size of the filename for this file */
				FilenameSize = DragQueryFile(DropHandle, i, NULL, 0);

				if (FilenameSize>MaxFilenameSize)
				{
					/* update max filename size if the length of this
					filename is greater than current */
					MaxFilenameSize = FilenameSize;
				}
			}

			/* allocate memory for filenames to use */
			pFilenameBuffer = (TCHAR *)malloc((MaxFilenameSize+2)*sizeof(TCHAR));

			if (pFilenameBuffer!=NULL)
			{
				for (i=0; i<NoOfFilesDropped; i++)
				{
					/* get this filename */
					DragQueryFile(DropHandle, i, pFilenameBuffer, MaxFilenameSize+1);

					/* do function to detect what this file is and
					 to load it if necessary */

					CPCEMU_DetectFileAndLoad(pFilenameBuffer);
				}

				/* free buffer to hold filenames */
				free(pFilenameBuffer);
			}
		}

		/* finish */
		DragFinish(DropHandle);
	}
}
/*----------------------------------------------------------------------------------------------*/
enum
{
	ZIP_SUPPORT_NOT_ZIP,		/* not a zip file */
	ZIP_SUPPORT_ZIP_OK,			/* a zip file and user selected a file */
	ZIP_SUPPORT_ZIP_CANCEL,		/* a zip file but user selected cancel */
	ZIP_SUPPORT_ZIP_ERROR,		/* a zip file but there was an error */
};
#if 0
/* returns NULL if the file is not a zip file or there are problems with it,
otherwise returns name of file extracted from zip */
int Interface_HandleZipFile(const HWND hwnd, const TCHAR *pFilename, TCHAR *OutputFilename)
{
	int nStatus = ZIP_SUPPORT_NOT_ZIP;

	if (ZipSupport_IsZipArchive(pFilename)==ZIP_SUPPORT_OK)
	{
		file_list theFileList;
		archive_file_open fileOpen;

		file_list_init(&theFileList);

		/* generate file list */
		ZipSupport_GenerateFileList(pFilename, &theFileList);

		/* show file selector */
		if (ArchiveUI_Show(hwnd,&theFileList,&fileOpen))
		{
			/* generate temp filename for output */
			GenerateTempFilename(OutputFilename);

			/* extract from archive to temp file */
			if (ZipSupport_ExtractFile(pFilename, fileOpen.pFilename, OutputFilename))
			{
				nStatus = ZIP_SUPPORT_ZIP_OK;
			}
			else
			{
				nStatus = ZIP_SUPPORT_ZIP_ERROR;
			}
		}
		else
		{
			nStatus = ZIP_SUPPORT_ZIP_CANCEL;
		}

		/* delete file list */
		file_list_delete(&theFileList);
	}

	return nStatus;
}
#endif
/*----------------------------------------------------------------------------------------------*/
static BOOL CALLBACK About_DialogProc(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch (uMsg)
	{
		case WM_INITDIALOG:
		{
			/* setup version/release text */
			TCHAR InfoText[256];

			/* the release date/version; defined at top of this file.
			Not based on file date of this file. */
			_stprintf(InfoText,_T("Release date %s"),sVersion);

#ifdef _DEBUG
#ifndef _INFO
#define _INFO
#endif
#endif

#ifdef _UNICODE
#ifndef _INFO
#define _INFO
#endif
#endif

#ifdef _INFO
			_tcscat(InfoText," (");
#endif

#ifdef _DEBUG
			/* only show if debug build. Don't bother reporting if release build */
			_tcscat(InfoText,"Debug Build.");
#endif

#ifdef _UNICODE
			/* only show if compiled for unicode. Don't bother otherwise */
			_tcscat(InfoText,"Unicode enabled.");
#endif

#ifdef _INFO
			_tcscat(InfoText,")");
#endif

#undef _INFO

			SetDlgItemText(hwndDlg, IDC_STATIC_INFO, InfoText);
		}
		break;

		/* white background; the background to the app logo is white */
		case WM_CTLCOLORSTATIC:
			return (BOOL)GetStockObject(WHITE_BRUSH);

		/* white background; the background to the app logo is white */
		case WM_CTLCOLORDLG:
			return (BOOL)GetStockObject(WHITE_BRUSH);

		case WM_COMMAND:
		{
			if (LOWORD(wParam)==IDOK)
				return EndDialog(hwndDlg, 0);
		}
		break;


		default:
			break;
	}

	return FALSE;
}
/*----------------------------------------------------------------------------------------------*/
typedef struct
{
	LPCTSTR sMessage;				/* message for message box */
	LPCTSTR sCaption;				/* caption for message box */
	BOOL	fCheck;					/* returns state of "show next time" checkbox */
	UINT	uType;					/* style of message box */
} MESSAGE_BOX_DATA;

#define WARNING_MESSAGE_BOX_SHOW_NEXT_TIME	0x8000
#define WARNING_MESSAGE_BOX_OK				0x0001
#define WARNING_MESSAGE_BOX_CANCEL			0x0002

/* this is static, because I can't work out how to use GetWindowLong(GWL_USERDATA) with a
modal dialog box :( */
static MESSAGE_BOX_DATA MessageBoxData;

static BOOL CALLBACK WarningMessageBox_DialogProc(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch (uMsg)
	{
		case WM_INITDIALOG:
		{
			int i;
			int nDefButton;

			const int ButtonIds[]={
				IDOK,
				IDCANCEL
			};

			/* get the static which shows the icon */
			HWND hIconStatic = GetDlgItem(hwndDlg, IDC_WARNING_ICON);

			/* load the icon */
			HICON hIcon = LoadIcon(NULL, IDI_WARNING);

			/* set the icon */
			SendMessage(hIconStatic, STM_SETICON, (WPARAM)hIcon, (LPARAM)0);

			/* set the title text */
			SetWindowText(hwndDlg, MessageBoxData.sCaption);

			/* set the message text */
			SetDlgItemText(hwndDlg, IDC_WARNING_MESSAGE, MessageBoxData.sMessage);

			/* set the text on the buttons; is there a proper way to get the correct
			language?? */
			switch (MessageBoxData.uType & MB_TYPEMASK)
			{
				case MB_OKCANCEL:
				{
					SetDlgItemText(hwndDlg, IDOK, _T("Ok"));
					SetDlgItemText(hwndDlg, IDCANCEL, _T("Cancel"));
				}
				break;

				case MB_YESNO:
				{
					SetDlgItemText(hwndDlg, IDOK, _T("Yes"));
					SetDlgItemText(hwndDlg, IDCANCEL, _T("No"));
				}
				break;

				default:
					break;
			}

			/* set the default button */
			nDefButton = MessageBoxData.uType & MB_DEFMASK;

			for (i=0; i<2; i++)
			{
				HWND hwndButton;
				DWORD nStyle;
				DWORD nStyleOrMask = 0;

				if (i==nDefButton)
				{
					nStyleOrMask = BS_DEFPUSHBUTTON;
				}
				/* get button */
				hwndButton = GetDlgItem(hwndDlg, ButtonIds[i]);
				/* adjust style */
				nStyle = GetWindowLong(hwndButton,GWL_STYLE);
				nStyle&=~BS_DEFPUSHBUTTON;
				nStyle|=nStyleOrMask;
				SetWindowLong(hwndButton, GWL_STYLE,nStyle);
			}

			CheckDlgButton(hwndDlg, IDC_CHECK_SHOW_WARNING, BST_CHECKED);
		}
		break;

		case WM_COMMAND:
		{
			if ((LOWORD(wParam)==IDOK) || (LOWORD(wParam)==IDCANCEL))
			{
				/* get check state */
				MessageBoxData.fCheck = IsDlgButtonChecked(hwndDlg, IDC_CHECK_SHOW_WARNING);

				/* end the dialog; returning ID of the button pressed */

				return EndDialog(hwndDlg, LOWORD(wParam));
			}
		}
		break;

		default:
			break;
	}

	return FALSE;
}

/* a MessageBox implementation which has a check box to control if the warning is shown again */
static int CPCEMU_WarningMessageBox(HWND hwndParent, LPCTSTR sMessage, LPCTSTR sCaption, UINT uType)
{
	int nStatus;
	int nID;

	MessageBoxData.sCaption = sCaption;
	MessageBoxData.sMessage = sMessage;
	MessageBoxData.uType = uType;

	nID = DialogBox((HINSTANCE)GetWindowLong(hwndParent, GWL_HINSTANCE),MAKEINTRESOURCE(IDD_DIALOG_WARNING),hwndParent, WarningMessageBox_DialogProc);

	nStatus = 0;
	if (nID==IDOK)
		nStatus |= WARNING_MESSAGE_BOX_OK;
	else if (nID==IDCANCEL)
		nStatus |= WARNING_MESSAGE_BOX_CANCEL;
	if (MessageBoxData.fCheck)
		nStatus |= WARNING_MESSAGE_BOX_SHOW_NEXT_TIME;

	return nStatus;
}


/*----------------------------------------------------------------------------------------------*/
BOOL CPCEMU_DoWarningMessageBox(HWND hwndParent, LPCTSTR sMessage, BOOL *fShowFlag)
{
	BOOL fDoAction = TRUE;

	//disable warning on fullscreen
	if (!AppData.Windowed) *fShowFlag = FALSE;

	/* show message box? */
	if (*fShowFlag)
	{
		int nStatus = CPCEMU_WarningMessageBox(hwndParent,sMessage,_T("Arnold"),MB_YESNO);

		/* show message box next time? */
		if ((nStatus&WARNING_MESSAGE_BOX_SHOW_NEXT_TIME)==0)
			*fShowFlag = FALSE;

		/* do reset? */
		fDoAction = FALSE;
		if (nStatus&WARNING_MESSAGE_BOX_OK)
			fDoAction = TRUE;
	}

	return fDoAction;
}

/*----------------------------------------------------------------------------------------------*/

void CPCEMU_DoReset(HWND hwndParent)
{
	if (CPCEMU_DoWarningMessageBox(hwndParent,_T("Are you sure you want to reset the Amstrad?\nAll unsaved data and RAM contents will be lost."), &fShowReset))
	{
		/* clear autotype */
		AutoType_Init();

		//Clear autorun
		AutoRunFile_Init();

		/* do reset */
		Computer_RestartReset();
	}
}

void CPCEMU_DoRestart(HWND hwndParent)
{
	if (CPCEMU_DoWarningMessageBox(hwndParent,_T("Are you sure you want to reset the Amstrad?\nAll unsaved data and RAM contents will be lost."), &fShowReset))
	{
		/* clear autotype */
		AutoType_Init();

		//Clear autorun
		AutoRunFile_Init();

		/* do restart */
		Computer_RestartPower();
	}
}

/*----------------------------------------------------------------------------------------------*/

BOOL CPCEMU_DoQuit(HWND hwndParent)
{
	return CPCEMU_DoWarningMessageBox(hwndParent,_T("Are you sure you want to exit Arnold?"),&fShowQuit);

}
/*----------------------------------------------------------------------------------------------*/

typedef struct
{
	const int nIconIndex;	/* icon in resources for this type */
	LPCTSTR sName;			/* name of this type */
	LPCTSTR sDescription;	/* description used in shell */
	LPCTSTR sLinkName;		/* link type used in shell */
} MEDIA_DATA;

/* these are used to group the extensions together */
/* so all extensions which are MEDIA_TYPE_DISK will share the same identification in the UI,
share the same icon and description in the shell and will be launched in the same way with Arnold */
const MEDIA_DATA Media[]=
{
	{IDI_ICON_DISK,_T("Disk"),_T("Amstrad CPC Disk Image File"),_T("Arnold.DskFile")},
	{IDI_ICON_CASSETTE,_T("Cassette"),_T("Amstrad CPC Tape Image File"), _T("Arnold.CdtFile")},
	{IDI_ICON_CARTRIDGE,_T("Cartridge"),_T("Amstrad CPC+ Cartridge File"),_T("Arnold.CprFile")},
	{IDI_ICON_SNAPSHOT,_T("Snapshot"),_T("Amstrad CPC Memory Snapshot File"),_T("Arnold.SnaFile")},

	/* add new media definitions here */
	/* these must be in the same order as defined in the enum below */
};

enum
{
	MEDIA_TYPE_DISK = 0,
	MEDIA_TYPE_CASSETTE,
	MEDIA_TYPE_CARTRIDGE,
	MEDIA_TYPE_SNAPSHOT
	/* add new media types here */
};

typedef struct
{
	LPCTSTR sExtension;		/* extension of this type */
	const int nMedia;				/* the media type to register it under */
} ASSOCIATION_DATA;

/* this defines the mapping of extensions to media types */
const ASSOCIATION_DATA Associations[]=
{
	{_T(".dsk"),MEDIA_TYPE_DISK},
	{_T(".cpr"),MEDIA_TYPE_CARTRIDGE},
	{_T(".cdt"),MEDIA_TYPE_CASSETTE},
	{_T(".tzx"),MEDIA_TYPE_CASSETTE},
	{_T(".csw"),MEDIA_TYPE_CASSETTE},
	{_T(".wav"),MEDIA_TYPE_CASSETTE},
	{_T(".voc"),MEDIA_TYPE_CASSETTE},
	{_T(".sna"),MEDIA_TYPE_SNAPSHOT},
	/* add new extensions here */
};
/*----------------------------------------------------------------------------------------------*/
void Associations_SelectAll(HWND hListView, BOOL fSelect)
{
	int i;

	DWORD nState = INDEXTOSTATEIMAGEMASK(1);
	if (fSelect)
	{
		nState = INDEXTOSTATEIMAGEMASK(2);
	}

	for (i=0; i<ListView_GetItemCount(hListView); i++)
	{
		ListView_SetItemState(hListView, i, nState, LVIS_STATEIMAGEMASK);
	}
}
/*----------------------------------------------------------------------------------------------*/

BOOL CALLBACK Associations_DialogProc(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch (uMsg)
	{
		case WM_INITDIALOG:
		{
			HWND hListView = GetDlgItem(hwndDlg,IDC_LIST_ASSOCIATIONS);
			int i;

//			ListView_SetExtendedListViewStyleEx(hListView, LVS_EX_CHECKBOXES ,LVS_EX_CHECKBOXES);

			/* create columns */
			MyListView_AddColumn(hListView, _T("Extension"), 0);
			MyListView_AddColumn(hListView, _T("Media"), 1);

			/* add items */
			for (i=0; i<sizeof(Associations)/sizeof(Associations[0]); i++)
			{
				int nMedia = Associations[i].nMedia;
				const MEDIA_DATA *pMedia = &Media[nMedia];

				MyListView_AddItem(hListView,(TCHAR*)Associations[i].sExtension,0,i, (void *)i);
				MyListView_AddItem(hListView,(TCHAR*)pMedia->sName, 1,i, (void *)i);
			}

			Associations_SelectAll(hListView, TRUE);
		}
		break;

		case WM_COMMAND:
		{
			WORD wID;

			wID = LOWORD(wParam);

			switch (wID)
			{
				case ID_SELECT_ALL:
				case ID_CLEAR_ALL:
				{
					HWND hListView = GetDlgItem(hwndDlg,IDC_LIST_ASSOCIATIONS);

					Associations_SelectAll(hListView, (wID==ID_SELECT_ALL));
				}
				break;

				case IDOK:
				{
					HWND hListView = GetDlgItem(hwndDlg,IDC_LIST_ASSOCIATIONS);
					int i;
					EXTENSION_INFO Extension;
					TCHAR Path[MAX_PATH];
					BOOL fOpenWith = FALSE;

					/* get filename and path of this executable */
					GetModuleFileName(NULL, Path, MAX_PATH);

					if (IsDlgButtonChecked(hwndDlg, IDC_CHECK_OPENWITHARNOLD))
						fOpenWith = TRUE;


					/* for those items which are checked, then associate */
					for (i=0; i<ListView_GetItemCount(hListView); i++)
					{
						/* get checked state */
						int nState = ListView_GetItemState(hListView, i,LVIS_STATEIMAGEMASK);
						int nAssociation = -1;
						BOOL fAssociate = FALSE;

						/* get data for item which is the index of the association */
						LVITEM Item;
						Item.mask = LVIF_PARAM;
						Item.iItem = i;
						Item.iSubItem = 0;
						if (ListView_GetItem(hListView,&Item))
						{
							const ASSOCIATION_DATA *pAssociation;
							const MEDIA_DATA *pMedia;
							int nMedia;

							nAssociation = (int)Item.lParam;
							pAssociation = &Associations[nAssociation];
							nMedia = pAssociation->nMedia;
							pMedia = &Media[nMedia];

							Extension.nIconIndex = pMedia->nIconIndex;
							Extension.pApplicationPath = Path;
							Extension.pExtensionDescription = pMedia->sDescription;
							Extension.pExtensionKeyName = pAssociation->sExtension;
							Extension.pExtensionLinkKeyName = pMedia->sLinkName;
						}

						if (nAssociation!=-1)
						{
							/* checked? */
							if (nState==INDEXTOSTATEIMAGEMASK(2))
								fAssociate = TRUE;

							if (fAssociate)
							{
								RegisterExtension(&Extension,FALSE);
							}

							if (fOpenWith)
							{
								RegisterExtension(&Extension,TRUE);
							}
						}
					}

				}
				return EndDialog(hwndDlg,1);

				case IDCANCEL:
					return EndDialog(hwndDlg,0);

				default:
					break;

			}
		}
		break;
	}

	return FALSE;
}
/*----------------------------------------------------------------------------------------------*/
void Associations_Dialog(HWND hwndParent)
{
	HINSTANCE hInstance = (HINSTANCE)GetWindowLong(hwndParent, GWL_HINSTANCE);

	DialogBox(hInstance, MAKEINTRESOURCE(IDD_DIALOG_ASSOCIATIONS),hwndParent, Associations_DialogProc);
}
/*----------------------------------------------------------------------------------------------*/
BOOL CALLBACK Snapshot_DialogProc(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch (uMsg)
	{
		case WM_INITDIALOG:
		{
			/* fill version combo */
			HWND hCombo = GetDlgItem(hwndDlg, IDC_COMBO_VERSION);

			ComboBoxHelper_InsertString(hCombo, 0, _T("2"));
			ComboBoxHelper_InsertString(hCombo, 1, _T("3"));
			ComboBoxHelper_InsertString(hCombo, 2, _T("3 Compressed"));

			ComboBoxHelper_SetCurSel(hCombo, 2);

			/* set check mark */
			CheckDlgButton(hwndDlg, IDC_CHECK_WRITE_2ND_64K,BST_CHECKED);
		}
		break;

		case WM_COMMAND:
		{
			WORD wID;

			wID = LOWORD(wParam);

			switch (wID)
			{
				case IDOK:
				{
					/* save the snapshot */
					HWND hCombo = GetDlgItem(hwndDlg, IDC_COMBO_VERSION);
					int nSel;

					if (IsDlgButtonChecked(hwndDlg,IDC_CHECK_WRITE_2ND_64K))
						SnapshotSettings_SetSizeToExport(&Options,(SNAPSHOT_SIZE)8);
					else
						SnapshotSettings_SetSizeToExport(&Options,(SNAPSHOT_SIZE)4);

					nSel = ComboBoxHelper_GetCurSel(hCombo);

					SnapshotSettings_SetCompressed(&Options, FALSE);

					switch (nSel)
					{
						case 0:
							SnapshotSettings_SetVersion(&Options,2);
							break;
						case 1:
							SnapshotSettings_SetVersion(&Options,3);
							break;
						case 2:
							SnapshotSettings_SetVersion(&Options,3);
							SnapshotSettings_SetCompressed(&Options,TRUE);
							break;
						default:
							SnapshotSettings_SetVersion(&Options,3);
							break;
					}


				}
				return EndDialog(hwndDlg, TRUE);

				case IDCANCEL:
					return EndDialog(hwndDlg, FALSE);

				default:
					break;
			}
		}
		break;

		default:
			break;
	}

	return FALSE;
}
/*----------------------------------------------------------------------------------------------*/

void SnapshotSave_Dialog(HWND hwndParent)
{
	HINSTANCE hInstance = (HINSTANCE)GetWindowLong(hwndParent,GWL_HINSTANCE);

	if (DialogBox(hInstance, MAKEINTRESOURCE(IDD_DIALOG_SNAPSHOT), hwndParent,Snapshot_DialogProc))
	{
		Interface_SaveSnapshot(hwndParent);
	}
}

#if 0
/*----------------------------------------------------------------------------------------------*/
typedef struct
{
	TCHAR *pPtr;			/* string to parse */
	unsigned long nOffset;		/* current character position */
	unsigned long nSize;		/* length in chars */
} DDEParse;

/*------------------------------------------------------------------------*/
void DDEParse_SkipWhitespace(DDEParse *pParse)
{
	TCHAR ch;

	if (pParse->nOffset==pParse->nSize)
		return;

	ch = pParse->pPtr[pParse->nOffset];
	pParse->nOffset++;

	while ((pParse->nOffset!=pParse->nSize) && ((ch==_T(' ')) || (ch==_T('\t'))))
	{
		ch = pParse->pPtr[pParse->nOffset];
		pParse->nOffset++;
	}

	if (pParse->nOffset!=pParse->nSize)
		pParse->nOffset--;
}
/*------------------------------------------------------------------------*/
/* escape a string. The reason to do this is so we can pass
quoted strings to our app and enclose them in quotes, so that they can be treated
as a single parameter */

/* TODO: Support escaped strings using \ ? */
LPCTSTR DDE_EscapeString(LPCTSTR sUnescapedString)
{
	int i;
	int nStringLen;
	int nOutputLen = 0;
	TCHAR *sEscapedString;

	nStringLen = _tcslen(sUnescapedString);

	/* escaped version of string may be longer! Calculate length */

	/* scan through input string calculating length of escaped string */
	for (i=0; i<nStringLen; i++)
	{
		TCHAR ch;

		ch = sUnescapedString[i];

		switch (ch)
		{
			/* escaped chars */
			case _T('"'):
			{
				nOutputLen++;
			}
			break;

			/* unescaped chars */
			default:
				break;
		}

		nOutputLen++;
	}

	sEscapedString = malloc((nOutputLen+1)*sizeof(TCHAR));

	if (sEscapedString)
	{
		int nOutputPos;

		nOutputPos = 0;

		for (i=0; i<nStringLen; i++)
		{
			TCHAR ch;

			ch = sUnescapedString[i];

			switch (ch)
			{
				/* escaped chars */
				case _T('"'):
				{
					sEscapedString[nOutputPos] = ch;
					nOutputPos++;
					sEscapedString[nOutputPos] = ch;
					nOutputPos++;
				}
				break;

				/* unescaped chars */
				default:
				{
					sEscapedString[nOutputPos] = ch;
					nOutputPos++;
				}
				break;
			}
		}

		sEscapedString[nOutputLen] = _T('\0');
	}

	return sEscapedString;

}

/*------------------------------------------------------------------------*/
/* TODO: Support escaped strings using \ ? */
LPCTSTR DDE_UnEscapeString(LPCTSTR sEscapedString)
{
	int nStringLen = _tcslen(sEscapedString);
	TCHAR *sUnescapedString;

	/* unescaped string may be less than length of this string, depending
	on if there are escape characters in the input string */
	/* allocate buffer large enough to hold escaped string and if unescaped
	string is smaller then some of the buffer is unused */
	sUnescapedString = malloc((nStringLen+1)*sizeof(TCHAR));

	if (sUnescapedString)
	{
		int nInputPos;
		int nOutputPos;

		nInputPos = 0;
		nOutputPos = 0;

		while (nInputPos!=nStringLen)
		{
			TCHAR ch;

			ch = sEscapedString[nInputPos];
			nInputPos++;

			/* look for escape char */
			if (ch==_T('"'))
			{
				if (nInputPos!=nStringLen)
				{
					ch = sEscapedString[nInputPos];
					nInputPos++;

					sUnescapedString[nOutputPos]=ch;
					nOutputPos++;
				}
			}
			else
			{
				/* not escape char, store to output */
				sUnescapedString[nOutputPos] = ch;
				nOutputPos++;
			}
		}

		/* null terminate string */
		sUnescapedString[nOutputPos] = _T('\0');
	}
	return sUnescapedString;
}

/*------------------------------------------------------------------------*/
/* get parameter */
TCHAR *DDEParse_GetParameter(DDEParse *pParse)
{
	TCHAR ch;
	BOOL fEscapeChar = FALSE;
	TCHAR chEscapeChar;
	BOOL fQuoted = TRUE;
	TCHAR *pStringStart;

	if (pParse->nOffset==pParse->nSize)
		return NULL;

	ch = pParse->pPtr[pParse->nOffset];

	/* parameter is initially quoted? */
	if (ch==_T('"'))
	{
		fQuoted = TRUE;
		pParse->nOffset++;
	}

	pStringStart = &pParse->pPtr[pParse->nOffset];

	while (pParse->nOffset!=pParse->nSize)
	{
		ch = pParse->pPtr[pParse->nOffset];

		if (!fEscapeChar)
		{
			if (ch==_T('"'))
			{
				/* seen quote, may be first quote of escaped quote */
				fEscapeChar = TRUE;
				chEscapeChar = _T('"');
			}
		}
		else
		{
			if (chEscapeChar==_T('"'))
			{
				/* seen an escaped quote */

				/* if we didn't see a second quote then quit */
				if (ch!='"')
				{
					pParse->pPtr[pParse->nOffset-1] = _T('\0');
					break;
				}
				else
				{
					/* saw second quote; this is an escaped quote! */
					fEscapeChar = FALSE;
				}
			}
		}

		pParse->nOffset++;
	}

	return pStringStart;
}
/*------------------------------------------------------------------------*/

void DDEParse_GetToken(DDEParse *pParse, TCHAR *TokenBuffer, unsigned long TokenBufferSize)
{
	TCHAR ch;
	unsigned long nTokenChars = 0;

	TokenBuffer[0] = _T('\0');

	if (pParse->nOffset==pParse->nSize)
		return;

	/* TODO: Support these chars only? [a-zA-Z0-9!#$%^&()-_{}~] */

	do
	{
		/* get character and advance position */
		ch = pParse->pPtr[pParse->nOffset];
		pParse->nOffset++;

		/* is a token character? */
		if (isalpha(ch))
		{
			/* can we fit any more chars into buffer? */
			if (nTokenChars<(TokenBufferSize-1))
			{
				/* add char */
				TokenBuffer[nTokenChars] = ch;
				nTokenChars++;
			}
		}
	}
	while (isalpha(ch) && (pParse->nOffset!=pParse->nSize));

	/* if we didn't hit the end of the parse buffer, go back one char */
	if (pParse->nOffset!=pParse->nSize)
	{
		pParse->nOffset--;
	}

	/* complete the token */
	TokenBuffer[nTokenChars]=_T('\0');
}
/*------------------------------------------------------------------------*/
HDDEDATA CALLBACK DdeClientCallback(UINT uType, UINT uFmt, HCONV hconv, HSZ hsz1, HSZ hsz2, HDDEDATA hData, DWORD dwData1, DWORD dwData2)
{
	return (HDDEDATA)0;
}
/*------------------------------------------------------------------------*/
HDDEDATA CALLBACK DdeCallback(UINT uType, UINT uFmt, HCONV hconv, HSZ hsz1, HSZ hsz2, HDDEDATA hData, DWORD dwData1, DWORD dwData2)
{

	switch (uType)
	{
		case XTYP_DISCONNECT:
			return 	(HDDEDATA)0;

		case XTYP_EXECUTE:
		{
			DWORD nSize;

			/* get length of buffer required */
			nSize = DdeGetData(hData,NULL,0,0);

			if (nSize!=0)
			{
				TCHAR *pBuffer = (TCHAR *)malloc(nSize+sizeof(TCHAR));

				if (pBuffer!=NULL)
				{
					/* copy the data */
					if (DdeGetData(hData, pBuffer, nSize, 0)==nSize)
					{
						DDEParse parse;
						TCHAR ch;

						pBuffer[nSize-1] = _T('\0');

						parse.nOffset = 0;
						parse.pPtr = pBuffer;
						parse.nSize = nSize;

						while (parse.nOffset!=parse.nSize)
						{
							ch = parse.pPtr[parse.nOffset];
							parse.nOffset++;

							if (ch==_T('['))
							{
								TCHAR TokenBuffer[32];

								DDEParse_GetToken(&parse, TokenBuffer, sizeof(TokenBuffer));

								if (_tcsicmp(TokenBuffer,_T("SetForeground"))==0)
								{



								}
								else if (_tcsicmp(TokenBuffer,_T("Open"))==0)
								{
									TCHAR *pString;

									DDEParse_SkipWhitespace(&parse);

									pString = DDEParse_GetParameter(&parse);

									if (pString!=NULL)
									{
										LPCTSTR pUnescapedString = DDE_UnEscapeString(pString);

										if (pUnescapedString)
										{
											CPCEMU_DetectFileAndLoad(pUnescapedString);

											free((void *)pUnescapedString);
										}
									}
								}
								else if (_tcsicmp(TokenBuffer,_T("CmdLine"))==0)
								{
									TCHAR *pString;

									DDEParse_SkipWhitespace(&parse);

									pString = DDEParse_GetParameter(&parse);

									if (pString!=NULL)
									{
										LPCTSTR pUnescapedString = DDE_UnEscapeString(pString);

										if (pUnescapedString)
										{
											CPCEMU_ProcessCommandLine(pUnescapedString);

											free((void *)pUnescapedString);
										}
									}
								}
							}
							else if (ch==_T(' '))
							{
								DDEParse_SkipWhitespace(&parse);
							}
							else if (ch==_T(']'))
							{


							}
						}
					}

					/* free the buffer */
					free(pBuffer);
				}
			}
		}
		return (HDDEDATA)DDE_FACK;


		case XTYP_CONNECT:
		{
			/* hsz1 = Topic Name;
			 hsz2 = Service name */
		   if (
			   (DdeCmpStringHandles(hsz1,AppData.hszSystemTopicName)==0) &&
			   (DdeCmpStringHandles(hsz2,AppData.hszAppName)==0)
				)
			{
			   /* topic/service supported */
				return (HDDEDATA)TRUE;
			}
		}
		return (HDDEDATA)FALSE;

		case XTYP_CONNECT_CONFIRM:
		{
		}
		break;

		default:
			break;

    }

	return (HDDEDATA)0;
}
#endif


/*------------------------------------------------------------------------*/
/* our own implementation of UNIX's getopt; not fully compatible! But UNICODE enabled */

struct option
{
	TCHAR *longname;		/* name of the long option */
	int has_arg;			/* 0 = no option, 1 = requires argument, 2 = optional argument */
	int *flag;				/* if NULL, getopt returns val */
							/* else getopt returns 0 and flag points to a variable
							which is set to val if the option is found, but left unchanged
							if the option is not found */
	int val;				/* val to return, or to load into variable pointed to by flag */
};

/*------------------------------------------------------------------------*/
/* assumes arg is NULL terminated string! */
/* returns pointer to arg string IF it is an arg, NULL otherwise */
static const TCHAR *getopt_long_only_isopt(TCHAR *arg)
{
	/* get first char */
	if (arg[0]==_T('-'))
	{
		/* first char is '-' */

		switch (arg[1])
		{
			/* has '--' prefix */
			case _T('-'):
			{
				/* now check next char */
				switch (arg[2])
				{
					/* exactly '--' */
					case _T('\0'):
						return NULL;

					default:
						break;
				}
			}
			return &arg[2];

			/* exactly '-' */
			case _T('\0'):
				return NULL;

			/* has '-' prefix */
			default:
				return &arg[1];
		}
	}

	/* not an arg */
	return NULL;
}

/*------------------------------------------------------------------------*/
const TCHAR *optarg;
const TCHAR *optarg2;

int optind;	/* not used */
int opterr=1; /* not used */
int optopt;

static int argpos;

/* UNIX version uses a static variable to keep track of processing options; this is useless
for us, because we may reuse the command-line function more than once */
void getopt_init()
{
	argpos= 1;
}
/* get next option */
int getopt_long_only(int argc, TCHAR **argv, const TCHAR *optstring, const struct option *options, int *longindex)
{
	const TCHAR *opt;

	/* check for end of arg list */
	if (argpos==argc)
		return -1;

	optarg = NULL;

	/* is this arg an option? */
	opt = getopt_long_only_isopt(argv[argpos]);
	argpos++;

	if (opt!=NULL)
	{
		const struct option *curopt= options;

		while (curopt->val!=0)
		{
			/* found? */
			if (_tcsicmp(curopt->longname, opt)==0)
			{
				switch (curopt->has_arg)
				{
					/* no argument */
					case 0:
						return curopt->val;

					/* argument required */
					case 1:
					{
						/* any more parameters */
						if (argpos!=argc)
						{
							opt = getopt_long_only_isopt((TCHAR *)argv[argpos]);

							if (opt==NULL)
							{
								/* setup argument */
								optarg = argv[argpos];
								argpos++;
							}
							return curopt->val;
						}

						/* error */
						/* - no parameters left in argument list */
						/* - next item in argument list is an option */
						optopt = curopt->val;
					}
					return '?';

					/* optional argument */
					case 2:
					{
						/* if no furthur arguments in list, assume argument not given and
						return value */
						if (argpos!=argc)
						{
							/* next is an option? */
							opt = getopt_long_only_isopt((TCHAR *)argv[argpos]);

							if (opt==NULL)
							{
								/* next not an option, so must be an argument */

								/* return it */
								optarg = argv[argpos];
								argpos++;
							}
						}
					}
					return curopt->val;
				}

			}

			curopt++;
		}

		/* end of list */
		return -1;
	}

	optarg = argv[argpos-1];

	return 1;
}

/*------------------------------------------------------------------------*/
/* execute command-line; passed to executable or passed via DDE from another instance
of Arnold app (or even another prog) */

/* the options we support */
const struct option long_options[] =
{
	/* the last column doesn't need to be converted into unicode!
	This column can almost be any integer value; but some values are reserved by
	the getopt function */
	{_T("tape"), 1, NULL, 't'},
	{_T("drivea"), 2, NULL, 'a'},
	{_T("driveb"), 1, NULL, 'b'},
	{_T("cart"), 1, NULL, 'c'},
	{_T("snapshot"), 1, NULL, 's'},
	{_T("fullscreen"), 1, NULL, 'f'},
	{_T("cpctype"), 1, NULL, 'd'},
	{NULL, 0, NULL, '\0'}
};

void CPCEMU_ProcessCommandLineAfter(LPCTSTR sCommandLine)
{
	CommandLineData commandLineData;
	char file[MAX_PATH];

	CommandLineData_Init(&commandLineData);
	if (sCommandLine)
	{
		int c;

		CommandLineData_Create(&commandLineData, sCommandLine);

		getopt_init();

		do
		{
			int option_index = 0;
			c = getopt_long_only(commandLineData.argc, commandLineData.argv, _T(""), long_options, &option_index);
			switch (c)
			{
				case 't':
				{
					unsigned char* pLocation;
					unsigned long Length;

					LoadFile(optarg, &pLocation, &Length);

					if (pLocation)
					{
						TapeImage_Insert(pLocation, Length);

						free(pLocation);
					}
				}
				break;
				case 'a':
				{
					strncpy(file, optarg, MAX_PATH);
					c = getopt_long_only(commandLineData.argc, commandLineData.argv, _T(""), long_options, &option_index);

					if (Interface_InsertDiskFromFile(0, file))
					{
						if (strcmp(optarg, "/A") == 0)
						{
							AutoRun(AutoType_String);
						}
					}
				}
				break;
				case 'b':
				{
					Interface_InsertDiskFromFile(1, optarg);
				}
				break;
				case 'c':
				{
					unsigned char* pLocation;
					unsigned long Length;

					LoadFile(optarg, &pLocation, &Length);

					if (pLocation)
					{
						Cartridge_AttemptInsert(pLocation, Length);

						free(pLocation);
					}
				}
				break;

				case 's':
				{
					unsigned char* pLocation;
					unsigned long Length;

					LoadFile(optarg, &pLocation, &Length);

					if (pLocation)
					{
						SNAPSHOT_MEMORY_BLOCKS SnapshotMemoryBlocks;
						Snapshot_CollectMemory(&SnapshotMemoryBlocks, SnapshotSettings_GetDefault(), TRUE);
						Snapshot_Insert(pLocation, Length, &SnapshotMemoryBlocks);

						free(pLocation);
					}
				}
				break;

				/* error */
				case '?':
				{
					c = -1;
				}
				break;

			}
		} while (c != -1);

		CommandLineData_Free(&commandLineData);
	}
}


void CPCEMU_ProcessCommandLineBefore(LPCTSTR sCommandLine)
{
	CommandLineData commandLineData;
	char file[MAX_PATH];

	CommandLineData_Init(&commandLineData);
	if (sCommandLine)
	{
		int c;

		CommandLineData_Create(&commandLineData, sCommandLine);

		getopt_init();

		do
		{
			int option_index = 0;
			c = getopt_long_only (commandLineData.argc, commandLineData.argv, _T(""), long_options, &option_index);
			switch(c)
			{

				case 'd':
				{
					int type = atoi(optarg);
					if (type < 0) type = 0;
					if (type > 5) type = 5;
					BasicCPCtype = type;
				}
				break;
				case 'f':
				{
					AppData.Windowed = false;
				}
				break;

				/* error */
				case '?':
				{
					c=-1;
				}
				break;


			}
		} while (c != -1);

		CommandLineData_Free(&commandLineData);
	}
}
/*----------------------------------------------------------------------------------------------*/

/* This will be checked now because Arnold is currently windowed only */
/* get the bits per pixel in current display mode */
BOOL	CheckBitDepth()
{
	HWND	DesktopWindow;
	int		BitsPerPixel = 0;

	/* get desktop window */
	DesktopWindow = GetDesktopWindow();

	if (DesktopWindow!=NULL)
	{
		HDC hDC;

		/* get DC of desktop window */
		hDC = GetDC(DesktopWindow);

		if (hDC!=NULL)
		{
			/* get device caps */
			BitsPerPixel = GetDeviceCaps(hDC, BITSPIXEL);

			/* release DC */
			ReleaseDC(DesktopWindow,hDC);
		}
	}

	/* check display depth */
	if (BitsPerPixel<8)
	{
		/* quit */
		return FALSE;
	}

	return TRUE;
}

/*----------------------------------------------------------------------------------------------*/
LPCTSTR GetString(const TCHAR *pString)
{
	if (pString==NULL)
		return _T("");

	return pString;
}


/*----------------------------------------------------------------------------------------------*/

BOOL CPCEMU_DetectFileAndLoad(const TCHAR *pFilename)
{
	unsigned char *pLocation;
	unsigned long Length;

	SNAPSHOT_MEMORY_BLOCKS SnapshotMemoryBlocks;

	LoadFile(pFilename, &pLocation, &Length);

	if (pLocation==NULL)
		return FALSE;

	if (Cartridge_AttemptInsert(pLocation, Length)==ARNOLD_STATUS_OK)
	{
		free(pLocation);
		return TRUE;
	}

	Snapshot_CollectMemory(&SnapshotMemoryBlocks, SnapshotSettings_GetDefault(), TRUE);
	if (Snapshot_Insert(pLocation, Length,&SnapshotMemoryBlocks)==ARNOLD_STATUS_OK)
	{
		free(pLocation);
		return TRUE;
	}

	if (TapeImage_Insert(pLocation, Length)==ARNOLD_STATUS_OK)
	{
		free(pLocation);
		return TRUE;
	}

	if (DiskImage_InsertDisk(0, pLocation, Length)==ARNOLD_STATUS_OK)
	{
		strcpy(DriveAFilename,pFilename);

		free(pLocation);
		return TRUE;
	}

	free(pLocation);
	return FALSE;
}
/*----------------------------------------------------------------------------------------------*/


void    CPC_ReloadSystemCartridge(void)
{
	Cartridge_Insert(CPCPLUS_SystemCartridge_ENG.pData, CPCPLUS_SystemCartridge_ENG.nLength);

	Cartridge_Autostart();
}







void	Interface_SetupCPCTypeMenu(int);

void	DoKeyboard(void);

void	ErrorMessage(TCHAR *ErrorText)
{
	MessageBox(GetActiveWindow(),ErrorText,Messages[70]/*_T(APP_TITLE_TEXT)*/,MB_OK);
}


enum
{
	EXTENSION_TEXT_ALL,
	EXTENSION_TEXT_DISK_IMAGES,
	EXTENSION_TEXT_DSK_IMAGE,
	EXTENSION_TEXT_DSK,
	EXTENSION_TEXT_ZIP,
	EXTENSION_TEXT_ARCHIVES,
	EXTENSION_TEXT_ZIP_ARCHIVE
};

TCHAR *ExtensionText[]=
{
	_T("All"),
	_T("Disk Images"),
	_T("DSK disk Image"),
	_T("dsk"),
	_T("zip"),
	_T("Archives"),
	_T("ZIP Archive")
};

/* an extension and it's description */
typedef struct
{
	/* ids are used for multi-language reasons */
	const int extensionTextID;
	const int descriptionTextID;
} EXTENSION_DATA;


// define the start of an extension group
#define EXTENSION_GROUP_BEGIN(_description_) \
{ \
	-1, \
	_description_ \
}

// define the end of an extension group
#define EXTENSION_GROUP_END() \
{ \
	-1, \
	-1, \
}

#define EXTENSION(_extension_, _description_) \
{ \
	_extension_, \
	_description_, \
}

#define EXTENSION_IS_GROUP_BEGIN(_item_) \
	((_item_->extensionTextID==-1) && (_item_->descriptionTextID!=-1))

#define EXTENSION_IS_GROUP_END(_item_) \
	((_item_->extensionTextID==-1) && (_item_->descriptionTextID==-1))

#define EXTENSION_IS_EXTENSION(_item_) \
	((_item_->extensionTextID!=-1) && (_item_->descriptionTextID!=-1))


const EXTENSION_DATA disc[]=
{
	EXTENSION_GROUP_BEGIN(EXTENSION_TEXT_ALL),
		EXTENSION_GROUP_BEGIN(EXTENSION_TEXT_DISK_IMAGES),
			EXTENSION(EXTENSION_TEXT_DSK,EXTENSION_TEXT_DSK_IMAGE),
		EXTENSION_GROUP_END(),
		EXTENSION_GROUP_BEGIN(EXTENSION_TEXT_ARCHIVES),
			EXTENSION(EXTENSION_TEXT_ZIP,EXTENSION_TEXT_ZIP_ARCHIVE),
		EXTENSION_GROUP_END(),
	EXTENSION_GROUP_END(),
};



#if 0
#define MENU_ITEM_DESC_FLAG_SEPERATOR (1<<0)
#define MENU_ITEM_DESC_FLAG_GREYED (1<<1)
#define MENU_ITEM_DESC_FLAG_SUBMENU_BEGIN (1<<2)
#define MENU_ITEM_DESC_FLAG_SUBMENU_END (1<<3)

typedef struct
{
	/* flags */
	int Flags;
	/* id of text */
	int TextID;
	/* id of selection */
	int ItemID;
} menu_item_desc;

#define MENU_BEGIN(_title_) \
{ \
	MENU_ITEM_DESC_FLAG_SUBMENU_BEGIN, \
	_title_, \
	0, \
} \

#define MENU_ITEM(_flags_,_textid_,_itemid_) \
{ \
	_flags_, \
	_textid_, \
	_itemid_ \
}


#define MENU_END() \
{ \
	MENU_ITEM_DESC_FLAG_SUBMENU_END, \
	0, \
	0, \
}

menu_item_desc menus[]=
{
	MENU_BEGIN("File"),
		MENU_BEGIN("Drive A"),
			MENU_BEGIN("Blank Disk"),
				MENU_ITEM("Unformatted"),0,ID_FILE_DRIVEA_INSERTNEWDISK_UNFORMATTED),
			MENU_END(),
		MENU_END(),
	MENU_END(),
};
#endif




/*------------------------------------------------------------------------------------------*/

static  TCHAR *EmptyString = _T("");



/*------------------------------------------------------------------------------------------*/
void	Interface_InsertUnformattedDisk(HWND hwndParent,int Drive)
{
	Interface_RemoveDisk(hwndParent,Drive);

	/* insert the unformatted disk */
	DiskImage_InsertUnformattedDisk(Drive);
}

/*------------------------------------------------------------------------------------------*/



extern unsigned char *Z80MemoryBase;



BOOL	Interface_ToggleItemState(HMENU hMenu,int Ident)
{
	MENUITEMINFO	MenuItemInfo;

	MenuItemInfo.cbSize = sizeof(MENUITEMINFO);
	MenuItemInfo.fMask = MIIM_STATE;

	if (GetMenuItemInfo(hMenu,Ident,FALSE,&MenuItemInfo)!=TRUE)
		return FALSE;


	if ((MenuItemInfo.fState & MFS_CHECKED)==MFS_CHECKED)
	{
		MenuItemInfo.fState &= ~(MFS_CHECKED | MFS_UNCHECKED);
		MenuItemInfo.fState |= MFS_UNCHECKED;
	}
	else
	{
		MenuItemInfo.fState &= ~(MFS_CHECKED | MFS_UNCHECKED);
		MenuItemInfo.fState |= MFS_CHECKED;
	}

	SetMenuItemInfo(hMenu,Ident,FALSE,&MenuItemInfo);

	return ((MenuItemInfo.fState & MFS_CHECKED)==MFS_CHECKED);
}


void	Interface_SetItemCheckState(HMENU hMenu, int Ident, BOOL Status)
{
	MENUITEMINFO	MenuItemInfo;

	/* get current state */
	MenuItemInfo.cbSize = sizeof(MENUITEMINFO);
	MenuItemInfo.fMask = MIIM_STATE;
	if (GetMenuItemInfo(hMenu, Ident, FALSE, &MenuItemInfo))
	{

		MenuItemInfo.fState &= ~(MFS_CHECKED | MFS_UNCHECKED);

		if (Status)
		{
			MenuItemInfo.fState |= MFS_CHECKED;
		}
		else
		{
			MenuItemInfo.fState |= MFS_UNCHECKED;
		}

		SetMenuItemInfo(hMenu,Ident,FALSE,&MenuItemInfo);
	}
}

void	Interface_SetItemGreyedState(HMENU hMenu, int Ident, BOOL Status)
{
	MENUITEMINFO	MenuItemInfo;

	/* get current state */
	MenuItemInfo.cbSize = sizeof(MENUITEMINFO);
	MenuItemInfo.fMask = MIIM_STATE;
	if (GetMenuItemInfo(hMenu, Ident, FALSE, &MenuItemInfo))
	{

		if (Status)
		{
			MenuItemInfo.fState |= MFS_GRAYED;
		}
		else
		{
			MenuItemInfo.fState &= ~MFS_GRAYED;
		}

		SetMenuItemInfo(hMenu,Ident,FALSE,&MenuItemInfo);
	}
}


void	SetCheckButtonState(HWND hDialog, int Ident, BOOL State)
{
	if (State == TRUE)
	{
		CheckDlgButton(hDialog, Ident,BST_CHECKED);
	}
	else
	{
		CheckDlgButton(hDialog, Ident, BST_UNCHECKED);
	}
}




/*----------------------------------------- */


void	Interface_SetupCPCTypeMenu(int CPCType)
{
	BOOL CPC464_ENABLED = FALSE;
	BOOL CPC664_ENABLED = FALSE;
	BOOL CPC6128_ENABLED = FALSE;
	BOOL CPC464PLUS_ENABLED = FALSE;
	BOOL CPC6128PLUS_ENABLED = FALSE;
	BOOL KCCOMPACT_ENABLED = FALSE;

	switch (CPCType)
	{
		case CPC_TYPE_CPC464_EN:
		case CPC_TYPE_CPC464_FR:
		case CPC_TYPE_CPC464_DK:
			CPC464_ENABLED = TRUE;
			break;
		case CPC_TYPE_CPC664:
			CPC664_ENABLED = TRUE;
			break;
		case CPC_TYPE_CPC6128_EN:
		//case CPC_TYPE_CPC6128_FR:
		//case CPC_TYPE_CPC6128_ES:
			CPC6128_ENABLED = TRUE;
			break;
		case CPC_TYPE_464PLUS:
			CPC464PLUS_ENABLED = TRUE;
			break;
		case CPC_TYPE_6128PLUS:
			CPC6128PLUS_ENABLED = TRUE;
			break;
		case CPC_TYPE_KCCOMPACT:
			KCCOMPACT_ENABLED = TRUE;
			break;
	}

	Interface_SetItemCheckState(AppData.hAppMenu, ID_CPCTYPE_CPC464,CPC464_ENABLED);
	Interface_SetItemCheckState(AppData.hAppMenu, ID_CPCTYPE_CPC664,CPC664_ENABLED);
	Interface_SetItemCheckState(AppData.hAppMenu, ID_CPCTYPE_CPC6128,CPC6128_ENABLED);
	Interface_SetItemCheckState(AppData.hAppMenu, ID_CPCTYPE_464PLUS,CPC464PLUS_ENABLED);
	Interface_SetItemCheckState(AppData.hAppMenu, ID_CPCTYPE_6128PLUS,CPC6128PLUS_ENABLED);
	Interface_SetItemCheckState(AppData.hAppMenu, ID_CPCTYPE_KCCOMPACT,KCCOMPACT_ENABLED);
}

const int CRTC_TypeArray[]=
{
	ID_CRTCTYPE_TYPE0,
	ID_CRTCTYPE_TYPE1,
	ID_CRTCTYPE_TYPE2,
	ID_CRTCTYPE_TYPEASIC,
	ID_CRTCTYPE_TYPEPREASIC,
};

const int NUM_CRTCS = (sizeof(CRTC_TypeArray)/sizeof(int));

// 491 520

void	Interface_SetupCRTCTypeMenu(int TypeIndex)
{
	int i;

	BOOL CRTC_Type_Enabled[NUM_CRTC_TYPES];

	for (i=0; i<NUM_CRTC_TYPES; i++)
	{
		CRTC_Type_Enabled[i] = FALSE;
	}

	CRTC_Type_Enabled[TypeIndex] = TRUE;

	for (i=0; i<NUM_CRTC_TYPES; i++)
	{
		Interface_SetItemCheckState(AppData.hAppMenu, CRTC_TypeArray[i],CRTC_Type_Enabled[i]);
	}
}


//======================================================================//


static void	Interface_UpdateRamConfig()
{
	unsigned long RamConfig;
	BOOL RAM_64K_ENABLED = FALSE;
	BOOL RAM_256K_ENABLED = FALSE;
	BOOL RAM_256K_SILICON_DISK_ENABLED = FALSE;

	RamConfig = CPC_GetRamConfig();

	if (RamConfig == CPC_RAM_CONFIG_64K_RAM)
	{
		RAM_64K_ENABLED = TRUE;
	}

	if (RamConfig == CPC_RAM_CONFIG_256K_RAM)
	{
		RAM_256K_ENABLED = TRUE;
	}

	if (RamConfig == CPC_RAM_CONFIG_256K_SILICON_DISK)
	{
		RAM_256K_SILICON_DISK_ENABLED = TRUE;
	}

	Interface_SetItemCheckState(AppData.hAppMenu, ID_MISC_RAMCONFIG_128K,RAM_64K_ENABLED);
	Interface_SetItemCheckState(AppData.hAppMenu, ID_MISC_RAMCONFIG_256KRAMEXPANSION,RAM_256K_ENABLED);
	Interface_SetItemCheckState(AppData.hAppMenu, ID_MISC_RAMCONFIG_256KSILICONDISK,RAM_256K_SILICON_DISK_ENABLED);
}


/*----------------------------------------------------------------------------------------------*/
BOOL CALLBACK PokeMemory_DialogProc(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch (uMsg)
	{
		case WM_COMMAND:
		{
			WORD wID;

			wID = LOWORD(wParam);

			switch (wID)
			{
				case IDOK:
				{
					char sText[256];
					Z80_WORD nAddress;
					Z80_BYTE nValue;

					GetDlgItemText(hwndDlg, IDC_EDIT_ADDRESS, sText, sizeof(sText)/sizeof(TCHAR));

					nAddress = (Z80_WORD)NumericChain(sText);

					GetDlgItemText(hwndDlg, IDC_EDIT_VALUE, sText, sizeof(sText)/sizeof(TCHAR));

					nValue = (Z80_BYTE)NumericChain(sText);

					/* do the poke */
					Z80_WR_MEM(nAddress,nValue);
				}
				return EndDialog(hwndDlg, TRUE);

				case IDCANCEL:
					return EndDialog(hwndDlg, FALSE);
			}
		}
		break;

		default:
			break;
	}

	return FALSE;
}

/*----------------------------------------------------------------------------------------------*/



BOOL CALLBACK AutoType_DialogProc(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch (uMsg)
	{
		case WM_INITDIALOG:
		{
			HWND hEdit = GetDlgItem(hwndDlg, IDC_EDIT_AUTOTYPE_TEXT);

			/* limit the amount of text that can be entered */
			SendMessage(hEdit, EM_LIMITTEXT, (WPARAM)256, (LPARAM)0);

		}
		break;

		case WM_COMMAND:
		{
			WORD wID;

			wID = LOWORD(wParam);

			switch (wID)
			{
				case IDOK:
				{
#ifdef _UNICODE
					TCHAR AutoTypeText_UNICODE[256];
					const char *AutoTypeText;

					GetDlgItemText(hwndDlg, IDC_EDIT_AUTOTYPE_TEXT,AutoTypeText, sizeof(AutoTypeText)/sizeof(AutoTypeText[0]));

					AutoTypeText = ConvertUnicodeStringToMultiByte(AutoTypeText_UNICODE);

					if (AutoTypeText)
					{
						strcpy(AutoTypeText, AutoType_String);

						free(AutoTypeText);
					}
#else
					GetDlgItemText(hwndDlg, IDC_EDIT_AUTOTYPE_TEXT,AutoType_String, sizeof(AutoType_String)/sizeof(AutoType_String[0]));
#endif
				}
				return EndDialog(hwndDlg, TRUE);

				case IDCANCEL:
				{

				}
				return EndDialog(hwndDlg, FALSE);
			}
		}
		break;
	}

	return FALSE;
}
/*----------------------------------------------------------------------------------------------*/





//////////////////////////////////////////////////////////////////////////////////////
WNDPROC PreviousMessageHandler;

LRESULT CALLBACK	Interface_MessageHandler(HWND hwnd, UINT iMsg, WPARAM wParam, LPARAM lParam)
{
	HINSTANCE hInstance = (HINSTANCE)GetWindowLong(hwnd,GWL_HINSTANCE);

	switch (iMsg)
	{
		case WM_COMMAND:
		{

			WORD wID = LOWORD(wParam);

			if (RecentItems_Handle(wID))
				return 0;

			switch (wID)
			{
				case ID_FILE_CASSETTE_CONTROLS:
				{
					CassetteControls(hwnd);
				}
				break;

				// drive A
				case ID_FILE_DRIVEA_INSERTDISK:
					Interface_InsertDisk(hwnd,0,AutoType_String,FALSE);
					return 0;

				case ID_FILE_DISKDRIVEA_LOADSTARTDISK:
					Interface_InsertDisk(hwnd,0,AutoType_String,TRUE);
					return 0;

				case ID_FILE_DISKDRIVEA_AUTOSTARTDISK:
					AutoRun(AutoType_String);
					return 0;

				case ID_FILE_DRIVEA_REMOVEDISK:
					Interface_RemoveDisk(hwnd,0);
					return 0;
				case ID_FILE_DRIVEA_TURNOVERDISK:
					FDD_TurnDiskToSideB(0,FALSE);
					return 0;
				case ID_FILE_DRIVEA_INSERTNEWDISK_UNFORMATTED:
					Interface_InsertUnformattedDisk(hwnd,0);
					return 0;

				// drive B
				case ID_FILE_DRIVEB_INSERTDISK:
					Interface_InsertDisk(hwnd,1,AutoType_String,FALSE);
					return 0;
				case ID_FILE_DRIVEB_REMOVEDISK:
					Interface_RemoveDisk(hwnd,1);
					return 0;
				case ID_FILE_DRIVEB_TURNOVERDISK:
					FDD_TurnDiskToSideB(1,FALSE);
					return 0;
				case ID_FILE_DRIVEB_INSERTNEWDISK_UNFORMATTED:
					Interface_InsertUnformattedDisk(hwnd,0);
					return 0;

				// cartridge
				case ID_FILE_CARTRIDGE_INSERTCARTRIDGE:
					Interface_OpenCartridge(hwnd);
					return 0;

				case ID_FILE_CARTRIDGE_INSERTSYSTEMCARTRIDGE:
					{
						CartridgeFilename[0] = '\0';
						CPC_ReloadSystemCartridge();
					}
					return 0;

				case ID_HELP_ABOUT:
				{
					DialogBox(hInstance,MAKEINTRESOURCE(IDD_DIALOG_ABOUT), hwnd, About_DialogProc);
				}
				break;

				case ID_HELP_ARNOLDWEBSITE:
				{
					ShellExecute(hwnd, _T("open"), _T("http://arnold.emuunlim.com"),NULL,NULL,0);
				}
				break;

				case ID_TOOLS_AUTOTYPE:
				{
					AutoType_String[0]='\0';

					/* show the modal dialog box for the auto-type feature */
					if (DialogBox(hInstance, MAKEINTRESOURCE(IDD_DIALOG_AUTOTYPE), hwnd, AutoType_DialogProc)==TRUE)
					{
						if (strlen(AutoType_String))
						{
							//Remove the \n from string, because there is always \r\n, to avoid double CR.
							int i = 0;
							int l = strlen(AutoType_String);
							char *tmp = (char*) malloc (l+2);
							char *ret = tmp;
							while (i < l)
							{
								if (AutoType_String[i] != '\n') { *ret++ = AutoType_String[i]; }
								i++;
							}
							*ret = '\0';
							strncpy(AutoType_String,tmp,strlen(tmp));
							free (tmp);

							AutoType_SetString(AutoType_String,FALSE, FALSE, FALSE);
							
						}
					}
				}
				break;

				case ID_TOOLS_POKEMEMORY:
				{
					/* show the modal dialog box for the poke memory feature */
					DialogBox(hInstance, MAKEINTRESOURCE(IDD_DIALOG_POKEMEMORY), hwnd, PokeMemory_DialogProc);
				}
				break;

				case ID_FILE_SNAPSHOT_LOAD:
					Interface_LoadSnapshot(hwnd);
					return 0;
				case ID_FILE_SNAPSHOT_SAVE:
					SnapshotSave_Dialog(hwnd);
					return 0;

                case ID_FILE_LOADFILE:
                    Interface_LoadFile(hwnd);
                    return 0;

				case ID_FILE_WRITESCREENSNAPSHOT:
					Interface_SaveScreenSnapshot();
					return 0;

				case ID_FILE_INSERTROM:
					{
						Interface_RomDialog(hwnd);
					return 0;
					}


				case ID_FILE_TAPEIMAGE_INSERT:
					{
						Interface_InsertTape(hwnd,FALSE);
					}
					return 0;
				case ID_FILE_TAPE_AUTOSTARTTAPE:
					{
						Interface_InsertTape(hwnd,TRUE);
					}
					return 0;
				case ID_FILE_TAPEIMAGE_REMOVE:
					{
						Tape_Remove();
					}
					return 0;
//				case ID_FILE_TAPEIMAGE_REWINDTOSTART:
//					{
//						TapeImage_RewindToStart();
//					}
//					return 0;

				case ID_FILE_EXIT:
				{
					SendMessage(hwnd, WM_CLOSE,0,0);
				}
				break;

				case ID_MISC_RESET:
					CPCEMU_DoReset(hwnd);
					return 0;

				case ID_MISC_RESTART:
					CPCEMU_DoRestart(hwnd);
					return 0;

				case ID_MISC_PRINTEROUTPUT_DIGIBLASTER:
				{
					if (!EmuDevice_IsEnabled(dDigiblaster))
					{
						EmuDevice_Enable(dDigiblaster, TRUE);
						Interface_SetItemCheckState(AppData.hAppMenu, ID_MISC_PRINTEROUTPUT_DIGIBLASTER,TRUE);
					}
					else
					{
						EmuDevice_Enable(dDigiblaster, TRUE);
						Interface_SetItemCheckState(AppData.hAppMenu, ID_MISC_PRINTEROUTPUT_DIGIBLASTER,TRUE);
					}
				}
				break;				
				

				case ID_MISC_CHEATS_CHEATDATABASE:
				{
					CheatDatabaseDialog(hwnd);
				}
				break;

				case ID_ENABLE_SCANLINE:
				{
					if (accuracyLevel == RENDERING_ACCURACY_HIGH)
					{
						Interface_SetItemCheckState(AppData.hAppMenu, ID_ENABLE_SCANLINE,FALSE);
						Render_SetRenderingAccuracyForWindowedMode(RENDERING_ACCURACY_HIGHER);
						accuracyLevel = RENDERING_ACCURACY_HIGHER;
					}
					else
					{
						Interface_SetItemCheckState(AppData.hAppMenu, ID_ENABLE_SCANLINE,TRUE);
						Render_SetRenderingAccuracyForWindowedMode(RENDERING_ACCURACY_HIGH);
						accuracyLevel = RENDERING_ACCURACY_HIGH;
					}

					CPCEMU_SetWindowed();
				}
				break;

				case ID_MISC_INICRONRAMROMSETTINGS:
				{
					Interface_RAMROM_Dialog(hwnd);
				}
				break;

				case ID_SETTINGS_OPTIONS:
				{
					Options_PropertySheet(hwnd);
				}
				break;

				case ID_SETTINGS_REGISTERFILETYPES:
				{
					Associations_Dialog(hwnd);
				}
				break;

				case ID_VIEW_FULLSCREEN:
				{
					CPCEMU_SetFullScreen();
				}
				break;

				case ID_FULLSCREEN_RES1:
				{
					AppData.FullScreenWidth=800;
					AppData.FullScreenHeight=600;
				}
				break;
				case ID_FULLSCREEN_RES2:
				{
					AppData.FullScreenWidth=1024;
					AppData.FullScreenHeight=768;
				}
				break;
				case ID_FULLSCREEN_RES3:
				{
					AppData.FullScreenWidth=1280;
					AppData.FullScreenHeight=800;
				}
				break;
				case ID_FULLSCREEN_RES4:
				{
					AppData.FullScreenWidth=1920;
					AppData.FullScreenHeight=1200;
				}
				break;
				case ID_FULLSCREEN_RES5:
				{
					AppData.FullScreenWidth = 1920;
					AppData.FullScreenHeight = 1080;
				}
				break;

				case ID_MISC_MONITORTYPE_COLOUR:
					{
						CPC_SetMonitorType(CPC_MONITOR_COLOUR);
					}
					break;

				case ID_MISC_MONITORTYPE_GREENSCREEN:
					{
						CPC_SetMonitorType(CPC_MONITOR_GT64);
					}
					break;

				case ID_MISC_MONITORTYPE_GREYSCALE:
					{
						CPC_SetMonitorType(CPC_MONITOR_MM12);
					}
					break;

//				case ID_MISC_MONITORDISPLAYBRIGHTNESS_MAX:
//				{
//					CPC_SetMonitorBrightness(MONITOR_BRIGHTNESS_MAX);
//				}
//				break;
//
//				case ID_MISC_MONITORDISPLAYBRIGHTNESS_MIN:
//				{
//					CPC_SetMonitorBrightness(64);
//				}
//				break;
//
//				case ID_MISC_MONITORDISPLAYBRIGHTNESS_MIDDLE:
//				{
//					CPC_SetMonitorBrightness(128);
//				}
//				break;

				case ID_MISC_RAMCONFIG_128K:
				{
					BOOL State;

					State = Interface_ToggleItemState(AppData.hAppMenu, ID_MISC_RAMCONFIG_128K);

					if (State) CPC_SetRamConfig(CPC_RAM_CONFIG_64K_RAM);
					else CPC_SetRamConfig(0);

					Interface_UpdateRamConfig();
				}
				break;

				case ID_MISC_RAMCONFIG_256KRAMEXPANSION:
				{
					BOOL State;

					State = Interface_ToggleItemState(AppData.hAppMenu, ID_MISC_RAMCONFIG_256KRAMEXPANSION);

					if (State) CPC_SetRamConfig(CPC_RAM_CONFIG_256K_RAM);
					else CPC_SetRamConfig(0);

					CPC_SetRamConfig(CPC_RAM_CONFIG_256K_RAM);
					Interface_UpdateRamConfig();
				}
				break;

				case ID_MISC_RAMCONFIG_256KSILICONDISK:
				{
					/*
					BOOL State;
					unsigned long RamConfig;

					State = Interface_ToggleItemState(AppData.hAppMenu, ID_MISC_RAMCONFIG_256KSILICONDISK);
					RamConfig = CPC_GetRamConfig();

					if (State) RamConfig |= CPC_RAM_CONFIG_256K_SILICON_DISK;
					else RamConfig &= ~CPC_RAM_CONFIG_256K_SILICON_DISK;

					CPC_SetRamConfig(RamConfig);
					Interface_UpdateRamConfig();
					*/
				}
				break;
#ifdef MULTIFACE

				case ID_MISC_MULTIFACESTOP:
					{
					Multiface_Stop();
					}
					return 0;

				case ID_MISC_MULTIFACE_SETTINGS:
				{
					Interface_MultifaceDialog(hwnd);
				}
				break;
#endif

				case ID_SETTINGS_EMULATIONSETTINGS_JOYSTICKSELECTION1:
				{
					JoystickConfigurationDialog(hwnd,1);
				}
				break;
				case ID_SETTINGS_EMULATIONSETTINGS_JOYSTICKSELECTION2:
				{
					JoystickConfigurationDialog(hwnd,2);
				}
				break;
				case ID_SETTINGS_EMULATIONSETTINGS_JOYSTICKCONFIGURATION1:
				{
					ControlJoyDialog(hwnd,0);
				}
				break;
				case ID_SETTINGS_EMULATIONSETTINGS_JOYSTICKCONFIGURATION2:
				{
					ControlJoyDialog(hwnd,1);
				}
				break;

				case ID_CPCTYPE_CPC464:
				case ID_CPCTYPE_CPC664:
				case ID_CPCTYPE_CPC6128:
				case ID_CPCTYPE_464PLUS:
				case ID_CPCTYPE_6128PLUS:
				case ID_CPCTYPE_KCCOMPACT:
				{
					switch (LOWORD(wParam))
					{
						case ID_CPCTYPE_CPC464:
							CPCType = CPC_TYPE_CPC464_EN;
							break;
						case ID_CPCTYPE_CPC664:
							CPCType = CPC_TYPE_CPC664;
							break;
						default:
						case ID_CPCTYPE_CPC6128:
							CPCType = CPC_TYPE_CPC6128_EN;
							break;
						case ID_CPCTYPE_464PLUS:
							CPCType = CPC_TYPE_464PLUS;
							break;
						case ID_CPCTYPE_6128PLUS:
							CPCType = CPC_TYPE_6128PLUS;
							break;
						case ID_CPCTYPE_KCCOMPACT:
							CPCType = CPC_TYPE_KCCOMPACT;
							break;
					}
					CPC_SetCPCType(CPCType);
				}
				return 0;

				case ID_CRTCTYPE_TYPE0:
				case ID_CRTCTYPE_TYPE1:
				case ID_CRTCTYPE_TYPE2:
				case ID_CRTCTYPE_TYPEASIC:
				case ID_CRTCTYPE_TYPEPREASIC:
				{
					int CRTCType;

					switch (LOWORD(wParam))
					{
						default:
						case ID_CRTCTYPE_TYPE0:
							CRTCType = 0;
							break;
						case ID_CRTCTYPE_TYPE1:
							CRTCType = 1;
							break;
						case ID_CRTCTYPE_TYPE2:
							CRTCType = 2;
							break;
						case ID_CRTCTYPE_TYPEASIC:
							CRTCType = 3;
							break;
						case ID_CRTCTYPE_TYPEPREASIC:
							CRTCType = 4;
							break;
					}

					CPC_SetCRTCType(CRTCType);
					Interface_SetupCRTCTypeMenu(CRTCType);
				}
				return 0;

				case ID_MISC_HARDWAREONJOYSTICKPORT_JOYSTICK:
				{
					CPC_SetHardwareConnectedToJoystickPort(JOYSTICK_HARDWARE_JOYSTICK);
				}
				break;

				case ID_MISC_HARDWAREONJOYSTICKPORT_AMXMOUSE:
				{
					CPC_SetHardwareConnectedToJoystickPort(JOYSTICK_HARDWARE_AMX_MOUSE);
				}
				break;

				case ID_MISC_HARDWAREONJOYSTICKPORT_WESTPHASER:
				{
					CPC_SetHardwareConnectedToJoystickPort(JOYSTICK_HARDWARE_WESTPHASER);
				}
				break;

				case 	ID_MISC_HARDWAREONJOYSTICKPORT_SPANISHLIGHTGUN:
				{
					CPC_SetHardwareConnectedToJoystickPort(JOYSTICK_HARDWARE_SPANISH_LIGHTGUN);
				}
				break;

					return 0;


				default:
					break;
			//	}
			}
		}
		break;

		default:
			break;
	}

	return CallWindowProc(PreviousMessageHandler,hwnd,iMsg, wParam,lParam);
}

int CPCType;

int CPC_GetCPCType(void)
{
	return CPCType;
}

unsigned long CPC_GetRamConfig(void)
{
	if (EmuDevice_IsEnabled(PALDeviceIndex)) return CPC_RAM_CONFIG_64K_RAM;
	if (EmuDevice_IsEnabled(DkTronics256KB)) return CPC_RAM_CONFIG_256K_RAM;
	return 0;
}

void CPC_SetRamConfig(unsigned long a)
{
	EmuDevice_Enable(PALDeviceIndex, FALSE);
	EmuDevice_Enable(DkTronics256KB, FALSE);

	if ( a == CPC_RAM_CONFIG_64K_RAM) {
		EmuDevice_Enable(PALDeviceIndex, TRUE);
	}
	if ( a == CPC_RAM_CONFIG_256K_RAM) {
		EmuDevice_Enable(DkTronics256KB, TRUE);
	}
}

void CPC_SetCPCType(int type)
{

#if 1
	EmuDevice_Enable(PALDeviceIndex, FALSE);
	EmuDevice_Enable(DkTronics256KB, FALSE);
	Amstrad_DiscInterface_Uninstall();
	//Amstrad_RamExpansion_DeInstall();
	Cartridge_RemoveI();
	//UnRegisterAllDevices();
	ASIC_SetGX4000(FALSE);
#endif

	switch (type)
	{
	case CPC_TYPE_CPC464_EN:
		{
			CPC_SetExpLow(FALSE);

			CPC_SetOSRom(CPC464_OperatingSystemRom_ENG.pData,CPC464_OperatingSystemRom_ENG.nLength);
			CPC_SetBASICRom(CPC464_BASICRom_ENG.pData,CPC464_BASICRom_ENG.nLength);		

			CPC_SetHardware(CPC_HW_CPC);
		}
		break;

	case CPC_TYPE_CPC664:
		{
			CPC_SetExpLow(TRUE);

			CPC_SetOSRom(CPC664_OperatingSystemRom_ENG.pData,CPC664_OperatingSystemRom_ENG.nLength);
			CPC_SetBASICRom(CPC664_BASICRom_ENG.pData,CPC664_BASICRom_ENG.nLength);
			//CPC_SetDOSRom(AMSDOSRom_ENG.pData);
			Amstrad_DiscInterface_SetRom(AMSDOSRom_ENG.pData);
			Amstrad_DiscInterface_Install();

			CPC_SetHardware(CPC_HW_CPC);
		}
		break;

	default:
	case CPC_TYPE_CPC6128_EN:
		{
			CPC_SetExpLow(TRUE);

			CPC_SetOSRom(CPC6128_OperatingSystemRom_ENG.pData,CPC6128_OperatingSystemRom_ENG.nLength);
			CPC_SetBASICRom(CPC6128_BASICRom_ENG.pData,CPC6128_BASICRom_ENG.nLength);
			//CPC_SetDOSRom(AMSDOSRom_ENG.pData);


			Amstrad_DiscInterface_SetRom(AMSDOSRom_ENG.pData);
			Amstrad_DiscInterface_Install();

			EmuDevice_Enable(PALDeviceIndex, TRUE);

			CPC_SetHardware(CPC_HW_CPC);

		}
		break;

	case CPC_TYPE_CPC6128_EN_PARADOS:
		{
			CPC_SetExpLow(TRUE);

			CPC_SetOSRom(CPC6128_OperatingSystemRom_ENG.pData,CPC6128_OperatingSystemRom_ENG.nLength);
			CPC_SetBASICRom(CPC6128_BASICRom_ENG.pData,CPC6128_BASICRom_ENG.nLength);
			//CPC_SetDOSRom(PARADOS_ENG.pData);


			Amstrad_DiscInterface_SetRom(AMSDOSRom_ENG.pData);
			Amstrad_DiscInterface_Install();

			EmuDevice_Enable(PALDeviceIndex, TRUE);

			CPC_SetHardware(CPC_HW_CPC);

		}
		break;

	case CPC_TYPE_464PLUS:
		{
			CPC_SetExpLow(TRUE);
			CPC_SetHardware(CPC_HW_CPCPLUS);

			/* 128k ram */
			ASIC_SetR128(FALSE);
			/* disc interface */
			ASIC_SetR129(FALSE);

			Cartridge_SetDefault(CPCPLUS_SystemCartridge_ENG.pData, CPCPLUS_SystemCartridge_ENG.nLength);
			Cartridge_InsertDefault();

			ASIC_SetHasCassetteInterface(TRUE);
		}
		break;

	case CPC_TYPE_6128PLUS:
		{

			CPC_SetExpLow(TRUE);
			CPC_SetHardware(CPC_HW_CPCPLUS);

			Cartridge_SetDefault(CPCPLUS_SystemCartridge_ENG.pData, CPCPLUS_SystemCartridge_ENG.nLength);
			Cartridge_InsertDefault();
			/* 128k ram */
			ASIC_SetR128(TRUE);
			/* disc interface */
			ASIC_SetR129(TRUE);
			/* no cassette interface */
			ASIC_SetHasCassetteInterface(FALSE);


			
			if (Parados_enabled) 
			{

				//VerifyRomData(PARADOS_ENG.pData, PARADOS_ENG.nLength, 16384);
				//AMSDOS_GetUseableSize(&PARADOS_ENG.pData, &PARADOS_ENG.nLength);
				//EmuDevice_CopyRomData(ROM_PARADOS, 16384, PARADOS_ENG.pData, PARADOS_ENG.nLength);

				//Parados = DkTronics256KBRam_Init();

				//ExpansionRomData *pExpansionRomData = EmuDevice_GetExpansionRomData(3);
				//int nResult = ExpansionRom_SetRomData(pExpansionRomData, PARADOS_ENG.pData, PARADOS_ENG.nLength, 7);

			}


		}
		break;

	case CPC_TYPE_KCCOMPACT:
		{
			CPC_SetOSRom(KCC_OperatingSystemRom_ENG.pData,KCC_OperatingSystemRom_ENG.nLength);
			CPC_SetBASICRom(KCC_BASICRom_ENG.pData,KCC_BASICRom_ENG.nLength);
			CPC_SetHardware(CPC_HW_KCCOMPACT);
		}
		break;
	case CPC_TYPE_GX4000:
		{

			ASIC_SetGX4000(TRUE);
			CPC_SetExpLow(FALSE);
			CPC_SetHardware(CPC_HW_CPCPLUS);

			Cartridge_SetDefault(CPCPLUS_SystemCartridge_ENG.pData, CPCPLUS_SystemCartridge_ENG.nLength);
			Cartridge_InsertDefault();
			/* 128k ram */
			ASIC_SetR128(FALSE);
			/* disc interface */
			ASIC_SetR129(FALSE);
			/* no cassette interface */
			ASIC_SetHasCassetteInterface(FALSE);

		}
		break;
	}

	Interface_SetupCPCTypeMenu(CPCType);
	Interface_SetupCRTCTypeMenu(CPC_GetCRTCType());
	Interface_UpdateRamConfig();

	CPC_SetMonitorType(CPC_GetMonitorType());

	Keyboard_DetectLanguage();
	Computer_RestartReset();

	CPCType = type;
}

/*=====================================================================================*/

/********************************************************************************
 KEYBOARD
 ********************************************************************************/
void ToggleFullScreen(void)
{
	if (AppData.Windowed)
	{
		if (!AppData.FakeFS)
		{
			CPCEMU_SetFullScreen();
		}
		else
		{
			CPCEMU_SetWindowed(TRUE);
			Sleep(100);
		}
	}
	else
	{
		CPCEMU_SetWindowed();
		Sleep(100);
	}
}


typedef struct
{
	int PCKeyID;
	int ActionData;
	int Action;
} KeyboardRemap;



/*=====================================================================================*/

/*
void Joystick_InitDefaultSettings(void)
{
	joystickConfigs[0].Active = TRUE;
	joystickConfigs[0].CPCJoystickID = CPC_DIGITAL_JOYSTICK0;
	joystickConfigs[0].Type = JOYSTICK_SIMULATED_BY_KEYBOARD;
	joystickConfigs[0].realJoystickData.id = 0;
	joystickConfigs[0].simulatedJoystickData.Left = DIK_NUMPAD4;
	joystickConfigs[0].simulatedJoystickData.Right = DIK_NUMPAD6;
	joystickConfigs[0].simulatedJoystickData.Up = DIK_NUMPAD8;
	joystickConfigs[0].simulatedJoystickData.Down = DIK_NUMPAD2;
	joystickConfigs[0].simulatedJoystickData.Fire1 = DIK_NUMPAD5;
	joystickConfigs[0].simulatedJoystickData.Fire2 = DIK_NUMPAD0;

	joystickConfigs[1].Active = FALSE;
	joystickConfigs[1].CPCJoystickID = CPC_DIGITAL_JOYSTICK1;
	joystickConfigs[1].Type = JOYSTICK_REAL;
	joystickConfigs[1].realJoystickData.id = 4;
	joystickConfigs[1].simulatedJoystickData.Left = DIK_LEFT;
	joystickConfigs[1].simulatedJoystickData.Right = DIK_RIGHT;
	joystickConfigs[1].simulatedJoystickData.Up = DIK_UP;
	joystickConfigs[1].simulatedJoystickData.Down = DIK_DOWN;
	joystickConfigs[1].simulatedJoystickData.Fire1 = DIK_RCONTROL;
	joystickConfigs[1].simulatedJoystickData.Fire2 = -1;

}
*/
typedef struct
{
	/* controller e.g. joystick/joypad */
	int ControllerID;
	int ControllerType;
	int ControllerElement;
	int KeyboardCode;
} Controller2KeyboardRemap;

/* joystick mapped to key presses */
/* keys used to simulate a joystick */


/* cpc joystick 0 */
/* physical controller; map controller buttons to CPC joystick  */
/* simulated by keyboard; define keys + key to enable/disable  */

/* keyboard */


void HandleJoysticks(void)
{
	int i;
	JoyInfoSystem Joytmp;
	BOOL OSD = FALSE;

	for (i=0; i<2; i++)
	{

		Joytmp.x = 0;
		Joytmp.y = 0;
		Joytmp.buttons = -1;

		/* active? */
		if (Joystick_IsActive(i))
		{
			switch (Joystick_GetType(i))
			{
			case JOYSTICK_TYPE_REAL:
				{
					JoyInfoSystem joyInfo;

					/* read the real joystick */
					if (Joystick_Read(Joystick_GetPhysical(i), i , &joyInfo))
					{
						JoyConvertion(i,&joyInfo);
						Joytmp.x = joyInfo.x;
						Joytmp.y = joyInfo.y;
						Joytmp.buttons = joyInfo.buttons;
					}
					else
					{
						if (i == 0) Joystick_SetType(i,JOYSTICK_TYPE_SIMULATED_BY_KEYBOARD);
						else Joystick_Activate(i,FALSE);
					}

				}
				break;

				/* keyboard simulating a joystick */
			case JOYSTICK_TYPE_SIMULATED_BY_KEYBOARD:
				{
					/* key pressed? */
#if 0
					if (joystickConfigs[i].simulatedJoystickData.Left!=-1)
					{
						if (IsKeyPressed(joystickConfigs[i].simulatedJoystickData.Left))
						{
							x = JOYSTICK_DATA_AXIS_MIN;
						}
					}

					/* key pressed? */
					if (joystickConfigs[i].simulatedJoystickData.Right!=-1)
					{
						if (IsKeyPressed(joystickConfigs[i].simulatedJoystickData.Right))
						{
							x = JOYSTICK_DATA_AXIS_MAX;
						}
					}

					/* key pressed? */
					if (joystickConfigs[i].simulatedJoystickData.Up!=-1)
					{
						if (IsKeyPressed(joystickConfigs[i].simulatedJoystickData.Up))
						{
							y = JOYSTICK_DATA_AXIS_MIN;
						}
					}

					/* key pressed? */
					if (joystickConfigs[i].simulatedJoystickData.Down!=-1)
					{
						if (IsKeyPressed(joystickConfigs[i].simulatedJoystickData.Down))
						{
							y = JOYSTICK_DATA_AXIS_MAX;
						}
					}

					/* key pressed? */
					if (joystickConfigs[i].simulatedJoystickData.Fire1!=-1)
					{
						if (IsKeyPressed(joystickConfigs[i].simulatedJoystickData.Fire1))
						{
							buttons |= (1<<0);
						}
					}

					/* key pressed? */
					if (joystickConfigs[i].simulatedJoystickData.Fire2!=-1)
					{
						if (IsKeyPressed(joystickConfigs[i].simulatedJoystickData.Fire2))
						{
							buttons |= (1<<1);
						}
					}
#endif
				}
				break;
			}
		}

		
		switch (Joystick_PhysicalToID(i))
		{
		case CPC_DIGITAL_JOYSTICK0:
			OSD = changeMenu(Joytmp);
		case CPC_DIGITAL_JOYSTICK1:

			//Release joystick button
			Joystick_SetButton(i,0,FALSE);
			Joystick_SetButton(i,1,FALSE);

			if (!OSD)
			{
				if (Joytmp.buttons != -1)
				{
					switch (Joytmp.buttons)
					{
					case 0:
					case 1:
						Joystick_SetButton(i,Joytmp.buttons,TRUE);
						break;
					case 2:
						CPC_SetKey(CPC_KEY_RETURN);
						break;
					case 3:
						CPC_SetKey(CPC_KEY_SPACE);
						break;
					case 4:
						CPC_SetKey(CPC_KEY_ESC);
						break;
					case 5:
						ToogleOnScreenMenu(FALSE);
						break;
					case 6:
						SendMessage(AppData.ApplicationHwnd, WM_CLOSE,0,0);
						break;

					}

				}

				Joystick_SetXMovement(i, Joytmp.x);
				Joystick_SetYMovement(i, Joytmp.y);

			}
			break;
		default:
			break;
		}

	}
}

/*=====================================================================================*/

const TCHAR *ActionNames[]=
{
	_T("None"),
	_T("Set CPC Key"),
	_T("Reset CPC"),
	_T("Toggle Fullscreen/Windowed"),
	_T("Insert Disk Image into drive A"),
	_T("Insert Disk Image into drive B"),
	_T("Insert Cartridge"),
	_T("Load Snapshot"),
	_T("Save Snapshot"),
	_T("Insert Tape"),
};

enum
{
	ACTION_CPC_NONE,
	ACTION_SET_CPC_KEY,
	ACTION_CPC_RESET,
	ACTION_TOGGLE_FULLSCREEN,
	ACTION_INSERT_DISK_DRIVE_A,
	ACTION_INSERT_DISK_DRIVE_B,
	ACTION_INSERT_CARTRIDGE,
	ACTION_LOAD_SNAPSHOT,
	ACTION_SAVE_SNAPSHOT,
	ACTION_INSERT_TAPE,
	ACTION_SAVE_SCREENSHOT,
	ACTION_QUIT,
	ACTION_DEBUGSOUND
};


KeyboardRemap keyMap[]=
{
	{
		VK_CONTROL,
		CPC_KEY_CONTROL,
		ACTION_SET_CPC_KEY
	},
	{
		VK_NEXT,
		CPC_KEY_COPY,
		ACTION_SET_CPC_KEY,
	},
	/*
	{
		VK_RETURN,
		CPC_KEY_SMALL_ENTER,
		ACTION_SET_CPC_KEY
	},
	*/
	{
		VK_UP,
		CPC_KEY_CURSOR_UP,
		ACTION_SET_CPC_KEY
	},
	{
		VK_DOWN,
		CPC_KEY_CURSOR_DOWN,
		ACTION_SET_CPC_KEY
	},
	{
		VK_LEFT,
		CPC_KEY_CURSOR_LEFT,
		ACTION_SET_CPC_KEY
	},
	{
		VK_RIGHT,
		CPC_KEY_CURSOR_RIGHT,
		ACTION_SET_CPC_KEY
	},
	{
		VK_ESCAPE,
		CPC_KEY_ESC,
		ACTION_SET_CPC_KEY,
	},
	{
		0x31,
		CPC_KEY_1,
		ACTION_SET_CPC_KEY,
	},
	{
		0x32,
		CPC_KEY_2,
		ACTION_SET_CPC_KEY,
	},
	{
		0x33,
		CPC_KEY_3,
		ACTION_SET_CPC_KEY,
	},
	{
		0x34,
		CPC_KEY_4,
		ACTION_SET_CPC_KEY,
	},
	{
		0x35,
		CPC_KEY_5,
		ACTION_SET_CPC_KEY,
	},
	{
		0x36,
		CPC_KEY_6,
		ACTION_SET_CPC_KEY,
	},
	{
		0x37,
		CPC_KEY_7,
		ACTION_SET_CPC_KEY,
	},
	{
		0x38,
		CPC_KEY_8,
		ACTION_SET_CPC_KEY,
	},
	{
		0x39,
		CPC_KEY_9,
		ACTION_SET_CPC_KEY,
	},
	{
		0x30,
		CPC_KEY_ZERO,
		ACTION_SET_CPC_KEY,
	},
	{
		VK_BACK,
		CPC_KEY_DEL,
		ACTION_SET_CPC_KEY,
	},
	{
		0x51,
		CPC_KEY_Q,
		ACTION_SET_CPC_KEY,
	},
	{
		0x57,
		CPC_KEY_W,
		ACTION_SET_CPC_KEY,
	},
	{
		0x45,
		CPC_KEY_E,
		ACTION_SET_CPC_KEY,
	},
	{
		0x52,
		CPC_KEY_R,
		ACTION_SET_CPC_KEY,
	},
	{
		0x54,
		CPC_KEY_T,
		ACTION_SET_CPC_KEY,
	},
	{
		0x59,
		CPC_KEY_Y,
		ACTION_SET_CPC_KEY,
	},
	{
		0x55,
		CPC_KEY_U,
		ACTION_SET_CPC_KEY,
	},
	{
		0x49,
		CPC_KEY_I,
		ACTION_SET_CPC_KEY,
	},
	{
		0x4F,
		CPC_KEY_O,
		ACTION_SET_CPC_KEY,
	},
	{
		0x50,
		CPC_KEY_P,
		ACTION_SET_CPC_KEY,
	},
	{
		0x41,
		CPC_KEY_A,
		ACTION_SET_CPC_KEY,
	},
	{
		0x53,
		CPC_KEY_S,
		ACTION_SET_CPC_KEY,
	},
	{
		0x44,
		CPC_KEY_D,
		ACTION_SET_CPC_KEY,
	},
	{
		0x46,
		CPC_KEY_F,
		ACTION_SET_CPC_KEY,
	},
	{
		0x47,
		CPC_KEY_G,
		ACTION_SET_CPC_KEY,
	},
	{
		0x48,
		CPC_KEY_H,
		ACTION_SET_CPC_KEY,
	},
	{
		0x4A,
		CPC_KEY_J,
		ACTION_SET_CPC_KEY,
	},
	{
		0x4B,
		CPC_KEY_K,
		ACTION_SET_CPC_KEY,
	},
	{
		0x4C,
		CPC_KEY_L,
		ACTION_SET_CPC_KEY,
	},
	{
		0x5A,
		CPC_KEY_Z,
		ACTION_SET_CPC_KEY,
	},
	{
		0x58,
		CPC_KEY_X,
		ACTION_SET_CPC_KEY,
	},
	{
		0x43,
		CPC_KEY_C,
		ACTION_SET_CPC_KEY,
	},
	{
		0x56,
		CPC_KEY_V,
		ACTION_SET_CPC_KEY,
	},
	{
		0x42,
		CPC_KEY_B,
		ACTION_SET_CPC_KEY,
	},
	{
		0x4E,
		CPC_KEY_N,
		ACTION_SET_CPC_KEY,
	},
	{
		0x4D,
		CPC_KEY_M,
		ACTION_SET_CPC_KEY,
	},
	{
		VK_NUMPAD9,
		CPC_KEY_F9,
		ACTION_SET_CPC_KEY,
	},
	{
		VK_NUMPAD8,
		CPC_KEY_F8,
		ACTION_SET_CPC_KEY,
	},
	{
		VK_NUMPAD7,
		CPC_KEY_F7,
		ACTION_SET_CPC_KEY,
	},
	{
		VK_NUMPAD6,
		CPC_KEY_F6,
		ACTION_SET_CPC_KEY,
	},
	{
		VK_NUMPAD5,
		CPC_KEY_F5,
		ACTION_SET_CPC_KEY,
	},
	{
		VK_NUMPAD4,
		CPC_KEY_F4,
		ACTION_SET_CPC_KEY,
	},
	{
		VK_NUMPAD3,
		CPC_KEY_F3,
		ACTION_SET_CPC_KEY,
	},
	{
		VK_NUMPAD2,
		CPC_KEY_F2,
		ACTION_SET_CPC_KEY,
	},
	{
		VK_NUMPAD1,
		CPC_KEY_F1,
		ACTION_SET_CPC_KEY,
	},
	{
		VK_NUMPAD0,
		CPC_KEY_F0,
		ACTION_SET_CPC_KEY,
	},
	{
		VK_DECIMAL,
		CPC_KEY_FDOT,
		ACTION_SET_CPC_KEY,
	},
	{
		VK_SPACE,
		CPC_KEY_SPACE,
		ACTION_SET_CPC_KEY,
	},
	{
		VK_LSHIFT,
		CPC_KEY_SHIFT,
		ACTION_SET_CPC_KEY,
	},
	{
		VK_RSHIFT,
		CPC_KEY_SHIFT,
		ACTION_SET_CPC_KEY,
	},
	{
		VK_RETURN,
		CPC_KEY_RETURN,
		ACTION_SET_CPC_KEY,
	},
	{
		VK_CONTROL,
		CPC_KEY_CONTROL,
		ACTION_SET_CPC_KEY,
	},
	{
		VK_CAPITAL,
		CPC_KEY_CAPS_LOCK,
		ACTION_SET_CPC_KEY,
	},
	{
		VK_OEM_4,
		CPC_KEY_MINUS,
		ACTION_SET_CPC_KEY,
	},
	{
		VK_OEM_2,
		CPC_KEY_COMMA,
		ACTION_SET_CPC_KEY,
	},
	{
		VK_OEM_MINUS,
		CPC_KEY_COLON,
		ACTION_SET_CPC_KEY,
	},
	{
		VK_OEM_7,
		CPC_KEY_BACKSLASH,
		ACTION_SET_CPC_KEY,
	},
	{
		VK_OEM_5,
		CPC_KEY_FORWARD_SLASH,
		ACTION_SET_CPC_KEY,
	},
	{
		VK_OEM_3,
		CPC_KEY_SEMICOLON,
		ACTION_SET_CPC_KEY,
	},
	{
		VK_OEM_6,
		CPC_KEY_OPEN_SQUARE_BRACKET,
		ACTION_SET_CPC_KEY,
	},
	{
		VK_OEM_1,
		CPC_KEY_CLOSE_SQUARE_BRACKET,
		ACTION_SET_CPC_KEY,
	},
	{
		VK_OEM_8,
		CPC_KEY_AT,
		ACTION_SET_CPC_KEY,
	},
	{
		VK_OEM_PLUS,
		CPC_KEY_DOT,
		ACTION_SET_CPC_KEY,
	},
};

int keyMapSize = sizeof(keyMap)/sizeof(keyMap[0]);


/* modifiers */
#define KEYBOARD_SHORTCUT_MODIFIER_CTRL 0x01
#define KEYBOARD_SHORTCUT_MODIFIER_ALT 0x02
#define KEYBOARD_SHORTCUT_MODIFIER_SHIFT 0x04

typedef struct
{
	unsigned long nModifiers;
	unsigned long nKey;
	unsigned long nAction;
} KEYBOARD_SHORTCUT;

/* not const because they can be modified by user! */
KEYBOARD_SHORTCUT Shortcuts[]=
{
	{
		0, VK_F2, ACTION_LOAD_SNAPSHOT
	},
	{
		0, VK_F3, ACTION_INSERT_TAPE
	},
	{
		0, VK_F4, ACTION_SAVE_SNAPSHOT
	},
	{
		0, VK_F5, ACTION_CPC_RESET
	},
	{
		0, VK_F6, ACTION_INSERT_DISK_DRIVE_A,
	},
	{
		0, VK_F7, ACTION_INSERT_DISK_DRIVE_B,
	},
	{
		0, VK_F9, ACTION_TOGGLE_FULLSCREEN
	},
	{
		0, VK_F10, ACTION_QUIT
	},
	{
		0, VK_F11, ACTION_DEBUGSOUND
	},
	{
		0, VK_SNAPSHOT, ACTION_SAVE_SCREENSHOT
	},
};

void HandleKeyboard(void)
{
	int i;
	unsigned long nModifiers = 0;
	KEYBOARD_SHORTCUT *pShortCut;

	/* get modifiers */
	if (IsKeyPressed(VK_LCONTROL) || IsKeyPressed(VK_RCONTROL))
		nModifiers |= KEYBOARD_SHORTCUT_MODIFIER_CTRL;

	if (IsKeyPressed(VK_LMENU) || IsKeyPressed(VK_RMENU))
		nModifiers |= KEYBOARD_SHORTCUT_MODIFIER_ALT;

	if (IsKeyPressed(VK_LSHIFT) || IsKeyPressed(VK_RSHIFT))
		nModifiers |= KEYBOARD_SHORTCUT_MODIFIER_SHIFT;


	/* Shortcut part */
	pShortCut = Shortcuts;

	for (i=0; i<sizeof(Shortcuts)/sizeof(Shortcuts[0]); i++)
	{
		if (
			/* check modifiers */
			((pShortCut->nModifiers & nModifiers)==nModifiers) &&
			IsKeyPressed(pShortCut->nKey)
			)
		{
			switch (pShortCut->nAction)
			{
				/* perform action */
				case ACTION_CPC_RESET:
				{
					//CPCEMU_DoReset(AppData.ApplicationHwnd);
				}
				break;

				case ACTION_LOAD_SNAPSHOT:
				{
					Interface_LoadSnapshot(AppData.ApplicationHwnd);
				}
				break;

				case ACTION_SAVE_SNAPSHOT:
				{
					SnapshotSave_Dialog(AppData.ApplicationHwnd);
				}
				break;

				case ACTION_INSERT_CARTRIDGE:
				{
					Interface_OpenCartridge(AppData.ApplicationHwnd);
				}
				break;

				case ACTION_INSERT_TAPE:
				{
					Interface_InsertTape(AppData.ApplicationHwnd,FALSE);
				}
				break;

				case ACTION_TOGGLE_FULLSCREEN:
				{
					ToggleFullScreen();
				}
				break;

				case ACTION_INSERT_DISK_DRIVE_A:
				{
					Interface_InsertDisk(AppData.ApplicationHwnd,0,AutoType_String,FALSE);
				}
				break;

				case ACTION_INSERT_DISK_DRIVE_B:
				{
					Interface_InsertDisk(AppData.ApplicationHwnd,1,AutoType_String,FALSE);
				}
				break;

				case ACTION_SAVE_SCREENSHOT:
				{
					Interface_SaveScreenSnapshot();
				}
				break;

				case ACTION_QUIT:
				{
					SendMessage(AppData.ApplicationHwnd, WM_CLOSE,0,0);
				}
				break;

				case ACTION_DEBUGSOUND:
				{
					Debugsound();
				}
				break;
			}
		}

		pShortCut++;
	}
	{
		//static HKL layout=GetKeyboardLayout(0);
		//static char State[256];
		//UINT vk=MapVirtualKeyEx(scancode,1,layout);
		//return ToAsciiEx(vk,scancode,State,result,0,layout);
		// 2 et 59
		for (i=0; i<keyMapSize; i++)
		{
			if(GetAsyncKeyState(keyMap[i].PCKeyID) < 0) 
			{
				switch (keyMap[i].Action)
				{
					case ACTION_SET_CPC_KEY:
					{
						CPC_SetKey(keyMap[i].ActionData);
					}
					break;
				}
			}
		}
	}
}

/*=====================================================================================*/


/*=====================================================================================*/


////////////////////////////////

#include "../../cpc/magnum.h"
#include "../../cpc/gunstick.h"
#include "../../cpc/amxms.h"
#include "../../cpc/kempston.h"



void HandleMouse(void)
{
	AppData.MouseDeltaX = AppData.xPos - AppData.MousePosX;
	AppData.MouseDeltaY = AppData.yPos - AppData.MousePosY;
	AppData.MousePosX = AppData.xPos;
	AppData.MousePosY = AppData.yPos;

	AppData.LeftPressed = ((AppData.Buttons & MK_LBUTTON)!=0);
	AppData.RightPressed = ((AppData.Buttons & MK_RBUTTON)!=0);

	//KempstonMouse_Update(AppData.MouseDeltaX, AppData.MouseDeltaY, AppData.LeftPressed, AppData.RightPressed);


	{
		//AmxMouse_Update(AppData.MouseDeltaX, AppData.MouseDeltaY, AppData.LeftPressed, AppData.RightPressed);
	}

//	if (LeftPressed)
//	{
//		CRTC_LightPen_Trigger(MousePosX, MousePosY);
//	}

	//SpanishLightGun_Update(AppData.MousePosX, AppData.MousePosY, AppData.LeftPressed);

	//Magnum_Update(AppData.MousePosX, AppData.MousePosY, AppData.LeftPressed);
}





void DoKeyboard()
{
	CPC_ClearKeyboard();

    if (!(AppData.DoNotScanKeyboard))
	{
		HandleKeyboard();

		HandleMouse();

		HandleJoysticks();
	}

}

/*------------------------------------------- */

//DWORD	startTime, endTime, timeElapsed;
//float	ScrTime;
//float	PercentSpeed;

void	CPCEMU_SetWindowed(BOOL FakeFS)
{
	int ExStyle, Style;

	DD_ReleaseSurfacesAndRestoreVideoMode();

//	if (Windowed == FALSE)
//	{
//		DD_FullScreenToWindow();
//	}
//	else
//	{
//		DD_ShutdownWindowed();
//	}

	// enable some styles
	Style = GetWindowLong(AppData.ApplicationHwnd, GWL_STYLE);

	Style |= WS_BORDER | WS_CAPTION | WS_MINIMIZEBOX | WS_MAXIMIZEBOX | WS_SYSMENU;
//	Style &= WS_MAXIMIZEBOX;
	SetWindowLong(AppData.ApplicationHwnd, GWL_STYLE, Style);

	// remove ex-styles
	ExStyle = GetWindowLong(AppData.ApplicationHwnd, GWL_EXSTYLE);
	ExStyle &= ~WS_EX_TOPMOST;
	SetWindowLong(AppData.ApplicationHwnd, GWL_EXSTYLE, ExStyle);

 // winnt crashes here
	if (AppData.hAppMenu)
	{
		SetMenu(AppData.ApplicationHwnd, NULL);
		SetMenu(AppData.ApplicationHwnd,AppData.hAppMenu);

		RecentFiles_RefreshMenu( AppData.ApplicationHwnd);
	}

	if (FakeFS)
	{

		//Use full window diplay borderless
		// https://stackoverflow.com/questions/34462445/fullscreen-vs-borderless-window

		//RECT desktop;
		//const HWND hDesktop = GetDesktopWindow();
		//GetWindowRect(hDesktop, &desktop);

		SetWindowLong(AppData.ApplicationHwnd, GWL_STYLE, WS_POPUP | WS_VISIBLE);

		SetMenu(AppData.ApplicationHwnd, NULL);

		AppData.Windowed = FALSE;

		Render_SetDisplayWindowed(GetSystemMetrics(SM_CXSCREEN) , GetSystemMetrics(SM_CYSCREEN));
		//Render_SetDisplayWindowed(1500,1000);

		while(ShowCursor(false)>=0);

	}

	else
	{
		AppData.Windowed = TRUE;

		Render_SetDisplayWindowed();

		while (ShowCursor(true) < 0);

	}

}


void CPCEMU_SetFullScreen()
{
	int Style;

	DD_ReleaseSurfacesAndRestoreVideoMode();
//	if (Windowed == FALSE)
//	{
//		DD_FullScreenToWindow();
//	}
//	else
//	{
//		DD_ShutdownWindowed();
//	}
	
	// remove some styles
	Style = GetWindowLong(AppData.ApplicationHwnd, GWL_STYLE);
	Style &= ~(WS_BORDER | WS_CAPTION | WS_MAXIMIZEBOX | WS_MINIMIZEBOX | WS_SYSMENU);
	SetWindowLong(AppData.ApplicationHwnd, GWL_STYLE, Style);

	// remove current menu
	SetMenu(AppData.ApplicationHwnd, NULL);

//	if (Windowed==TRUE)
//	{
//		DD_FromWindowed();
//	}

	Render_SetDisplayFullScreen(AppData.FullScreenWidth, AppData.FullScreenHeight, AppData.FullScreenDepth);

	AppData.Windowed = FALSE;
	
	while (ShowCursor(false) >= 0);
}



#if 0
//static int timerID = 0;
static BOOL AudioEnabled = FALSE;

void	AudioEnable(BOOL State)
{
	if (State)
	{
		// is direct sound active ?
		if (Host_AudioPlaybackPossible())
		{
			timerID = timeSetEvent(1000/50, 2, MyTimerProc,0, TIME_PERIODIC);

			if (timerID!=0)
			{
				AudioEnabled = TRUE;


			}
		}
	}
	else
	{
		 //is timer active?
		if (timerID!=0)
		{
			//kill event
			timeKillEvent(timerID);

			timerID = 0;

			AudioEnabled = FALSE;
		}
	}
}
#endif

void	CPCEMU_SetupPalette()
{
    /* initialise palette for Windows. Mark some entries as un-matchable and used */
    int i;

    for (i=0; i<10; i++)
    {
        Render_MarkPaletteEntryForHostUse(i);

		Render_MarkPaletteEntryForHostUse(i+246);
	}
}


int	CPCEMU_Initialise(void)
{

	HINSTANCE	hInstance;

	// for windows ce this must not be NULL!
	HMODULE hModule = NULL;

	AutoType_Init();

	AutoRunFile_Init();

	PreviousMessageHandler = (WNDPROC)GetWindowLong(AppData.ApplicationHwnd, GWL_WNDPROC);

	SetWindowLong(AppData.ApplicationHwnd, GWL_WNDPROC,(LONG)Interface_MessageHandler);

	hInstance = (HINSTANCE)GetWindowLong(AppData.ApplicationHwnd,GWL_HINSTANCE);

	AppData.hAppMenu = LoadMenu(hInstance,MAKEINTRESOURCE(IDR_MENU1));

	/* get system cartridge from resources */
	GetDataFromCustomResource(hModule, &CPCPLUS_SystemCartridge_ENG.pData, &CPCPLUS_SystemCartridge_ENG.nLength, MAKEINTRESOURCE(CPCPLUS_SYSTEM));

	/* get cpc464 roms from resources */
	GetDataFromCustomResource(hModule, &CPC464_OperatingSystemRom_ENG.pData, &CPC464_OperatingSystemRom_ENG.nLength, MAKEINTRESOURCE(CPC464E_OS));
	GetDataFromCustomResource(hModule, &CPC464_BASICRom_ENG.pData, &CPC464_BASICRom_ENG.nLength, MAKEINTRESOURCE(CPC464E_BASIC));

	/* get cpc664 roms from resources */
	GetDataFromCustomResource(hModule, &CPC664_OperatingSystemRom_ENG.pData, &CPC664_OperatingSystemRom_ENG.nLength, MAKEINTRESOURCE(CPC664E_OS));
	GetDataFromCustomResource(hModule, &CPC664_BASICRom_ENG.pData, &CPC664_BASICRom_ENG.nLength, MAKEINTRESOURCE(CPC664E_BASIC));

	/* get cpc6128 roms from resources */
	GetDataFromCustomResource(hModule, &CPC6128_OperatingSystemRom_ENG.pData, &CPC6128_OperatingSystemRom_ENG.nLength, MAKEINTRESOURCE(CPC6128E_OS));
	GetDataFromCustomResource(hModule, &CPC6128_BASICRom_ENG.pData, &CPC6128_BASICRom_ENG.nLength, MAKEINTRESOURCE(CPC6128E_BASIC));

	/* get kcc roms from resources */
	GetDataFromCustomResource(hModule, &KCC_OperatingSystemRom_ENG.pData, &KCC_OperatingSystemRom_ENG.nLength, MAKEINTRESOURCE(KCC_KCCOS));
	GetDataFromCustomResource(hModule, &KCC_BASICRom_ENG.pData, &KCC_BASICRom_ENG.nLength, MAKEINTRESOURCE(KCC_KCCBAS));

	/* get amsdos rom from resources */
	GetDataFromCustomResource(hModule, &AMSDOSRom_ENG.pData, &AMSDOSRom_ENG.nLength, MAKEINTRESOURCE(AMSDOSE_AMSDOS));

	/* get parados rom from resources */
	GetDataFromCustomResource(hModule, &PARADOS_ENG.pData, &PARADOS_ENG.nLength, MAKEINTRESOURCE(PARADOS_ROM));

	/* initialise cpc hardware */
	CPC_Initialise();

	/*Set keyboard mode 0:positional 1:translated */
	Keyboard_SetMode(1);

	/* insert the cartridge */
	Cartridge_Insert(CPCPLUS_SystemCartridge_ENG.pData, CPCPLUS_SystemCartridge_ENG.nLength);

	// Drive initilaisation
	GenericInterface_Initialise();

	//setup ram rom (need to be before setting)
	PALDeviceIndex = PAL16L8_Init();
	//256k dk tronik
	DkTronics256KB = DkTronics256KBRam_Init();
	//Digiblaster
	dDigiblaster = DigiblasterDevice_Init();
	//Roms
	//RamRom_Init();

	//Multiface install
	//Multiface_Install();

	//Set Drive A for 3.5'' drive
	FDD_SetTracks(0, 84); //84 tracks
	FDD_SetDoubleSided(0, TRUE); // double side
	//FDD_SetAlwaysWriteProtected(0, TRUE); // write protected


	CPCEMU_SetupPalette();

	//Joystick
	Joystick_InitDefaultSettings();
	Joystick_Init();
	//retore joystick configuration
	Joystick_SetXRange(0, -32768, 32768);
	Joystick_SetYRange(0, -32768, 32768);
	Joystick_Reset(0);
	Joystick_SetXRange(1, -32768, 32768);
	Joystick_SetYRange(1, -32768, 32768);
	Joystick_Reset(1);

	// set acknowledge interrupt callback function
	//Z80_SetUserAckInterruptFunction(CPC_AcknowledgeInterrupt);

	//fps-speed
	ResetTiming();

	// restore Basic hardware config
	CPC_SetCPCType(BasicCPCtype);
	CPC_SetCRTCType(BasicCRTCtype);
	CPC_SetMonitorType(BasicMonitortype);

	// Restore Basic config
	Render_SetRenderingAccuracyForWindowedMode(RENDERING_ACCURACY_HIGHER);
		
	//setup menu
	Interface_SetupCRTCTypeMenu(CPC_GetCRTCType());
	Interface_SetupCPCTypeMenu(CPCType);

	//setup sound
	Audio_SetOutput(CPC_AUDIO_OUTPUT_STEREO);
	CPC_SetAudioActive(TRUE);

	Monitor_SetRendererReady(TRUE);
	
	return 1;
}

void	CPCEMU_Run(void)
{
		/* run emulation */
		CPCEmulation_Run();
}

void CPCEMU_Finish(void)
{

	/* store settings */
	GenericInterface_StoreSettings();

	//ClosePrinterFile();
	//labelsets_free();

	UnRegisterAllDevices();

	//Multiface_Finish();
	//Multiface_DeInstall();

	//AudioEnable(FALSE);
	CPC_SetAudioActive(FALSE);
	Audio_Finish();

	/* close CPC emulation */
	CPC_Finish();
	
	Render_Finish();

	AutoType_Finish();
    AutoRunFile_Finish();

	//ClosePrinterFile();
	WinapePokeDatabase_Free();

	return;
}




#ifndef _countof
   #define _countof(array) (sizeof(array)/sizeof((array)[0]))
#endif

#if 0

void CPCEMU_SetKey_VK(int vk, BOOL bKeyDown, BOOL bNumPad)
{
   static const struct _MAP
   {
      int        vk;
      CPC_KEY_ID cpc;
      CPC_KEY_ID cpc_add;
   } aMapMain[]=
   {
	   { VK_ESCAPE , CPC_KEY_ESC  , CPC_KEY_NULL } , /* 0 */

      { '1'       , CPC_KEY_1    , CPC_KEY_NULL } ,
	   { '!'       , CPC_KEY_1    , CPC_KEY_SHIFT} ,

      { '2'       , CPC_KEY_2    , CPC_KEY_NULL } ,
      { '"'       , CPC_KEY_2    , CPC_KEY_SHIFT} ,

      { '3'       , CPC_KEY_3    , CPC_KEY_NULL } ,
	   { '#'       , CPC_KEY_3    , CPC_KEY_SHIFT} ,

      { '4'       , CPC_KEY_4    , CPC_KEY_NULL } ,
	   { '$'       , CPC_KEY_4    , CPC_KEY_SHIFT} ,

      { '5'       , CPC_KEY_5    , CPC_KEY_NULL } ,
      { '%'       , CPC_KEY_5    , CPC_KEY_SHIFT} , /* 10 */

      { '6'       , CPC_KEY_6    , CPC_KEY_NULL } ,
      { '&'       , CPC_KEY_6    , CPC_KEY_SHIFT} ,

      { '7'       , CPC_KEY_7    , CPC_KEY_NULL } ,
      { '\''      , CPC_KEY_7    , CPC_KEY_SHIFT} ,

      { '8'       , CPC_KEY_8    , CPC_KEY_NULL } ,
      { '('       , CPC_KEY_8    , CPC_KEY_SHIFT} ,

      { '9'       , CPC_KEY_9    , CPC_KEY_NULL } ,
	   { ')'       , CPC_KEY_9    , CPC_KEY_SHIFT} ,

      { '0'       , CPC_KEY_ZERO , CPC_KEY_NULL } ,
	   { '_'       , CPC_KEY_ZERO , CPC_KEY_SHIFT} , /* 20 */

      { '-'       , CPC_KEY_MINUS , CPC_KEY_NULL } ,
      { '=_T('       , CPC_KEY_MINUS , CPC_KEY_SHIFT} ,

      { '^'       , CPC_KEY_HAT  , CPC_KEY_NULL } ,
      { ''       , CPC_KEY_HAT  , CPC_KEY_SHIFT} ,

	   { VK_BACK   , CPC_KEY_DEL  , CPC_KEY_NULL } ,
	   { VK_TAB    , CPC_KEY_TAB  , CPC_KEY_NULL } ,

      { 'q'       , CPC_KEY_Q    , CPC_KEY_NULL } ,
      { 'Q'       , CPC_KEY_Q    , CPC_KEY_SHIFT} ,

	   { 'w'       , CPC_KEY_W    , CPC_KEY_NULL } ,
	   { 'W'       , CPC_KEY_W    , CPC_KEY_SHIFT} , /* 30 */

      { 'e'       , CPC_KEY_E    , CPC_KEY_NULL } ,
      { 'E'       , CPC_KEY_E    , CPC_KEY_SHIFT} ,

      { 'r'       , CPC_KEY_R    , CPC_KEY_NULL } ,
      { 'R'       , CPC_KEY_R    , CPC_KEY_SHIFT} ,

      { 't'       , CPC_KEY_T    , CPC_KEY_NULL } ,
      { 'T'       , CPC_KEY_T    , CPC_KEY_SHIFT} ,

      { 'y'       , CPC_KEY_Y    , CPC_KEY_NULL } ,
      { 'Y'       , CPC_KEY_Y    , CPC_KEY_SHIFT} ,

      { 'u'       , CPC_KEY_U    , CPC_KEY_NULL } ,
      { 'U'       , CPC_KEY_U    , CPC_KEY_SHIFT} , /* 40 */

      { 'i'       , CPC_KEY_I    , CPC_KEY_NULL } ,
      { 'I'       , CPC_KEY_I    , CPC_KEY_SHIFT} ,

      { 'o'       , CPC_KEY_O    , CPC_KEY_NULL } ,
      { 'O'       , CPC_KEY_O    , CPC_KEY_SHIFT} ,

      { 'p'       , CPC_KEY_P    , CPC_KEY_NULL } ,
      { 'P'       , CPC_KEY_P    , CPC_KEY_SHIFT} ,

      { '@'       , CPC_KEY_AT   , CPC_KEY_NULL } ,
	   { '|'       , CPC_KEY_AT   , CPC_KEY_SHIFT } ,

      { '['       , CPC_KEY_OPEN_SQUARE_BRACKET , CPC_KEY_NULL } ,
      { '{'       , CPC_KEY_OPEN_SQUARE_BRACKET , CPC_KEY_SHIFT} , /* 50 */

      { VK_RETURN , CPC_KEY_RETURN , CPC_KEY_NULL } ,
      { '\n', CPC_KEY_RETURN , CPC_KEY_NULL } ,

      { 'a'       , CPC_KEY_A    , CPC_KEY_NULL } ,
	   { 'A'       , CPC_KEY_A    , CPC_KEY_SHIFT} ,

      { 's'       , CPC_KEY_S    , CPC_KEY_NULL } ,
	   { 'S'       , CPC_KEY_S    , CPC_KEY_SHIFT} ,

      { 'd'       , CPC_KEY_D    , CPC_KEY_NULL } ,
      { 'D'       , CPC_KEY_D    , CPC_KEY_SHIFT} ,

      { 'f'       , CPC_KEY_F    , CPC_KEY_NULL } ,
      { 'F'       , CPC_KEY_F    , CPC_KEY_SHIFT} ,

	   { 'g'       , CPC_KEY_G    , CPC_KEY_NULL } ,
	   { 'G'       , CPC_KEY_G    , CPC_KEY_SHIFT} ,

	   { 'h'       , CPC_KEY_H    , CPC_KEY_NULL } ,
	   { 'H'       , CPC_KEY_H    , CPC_KEY_SHIFT} ,

      { 'j'       , CPC_KEY_J    , CPC_KEY_NULL } ,
      { 'J'       , CPC_KEY_J    , CPC_KEY_SHIFT} ,

	   { 'k'       , CPC_KEY_K    , CPC_KEY_NULL } ,
	   { 'K'       , CPC_KEY_K    , CPC_KEY_SHIFT} ,

      { 'l'       , CPC_KEY_L    , CPC_KEY_NULL } ,
      { 'L'       , CPC_KEY_L    , CPC_KEY_SHIFT} ,

      { ':'       , CPC_KEY_COLON , CPC_KEY_NULL } ,
      { '*'       , CPC_KEY_COLON , CPC_KEY_SHIFT} ,

	   { ';'       , CPC_KEY_SEMICOLON , CPC_KEY_NULL } ,
	   { '+'       , CPC_KEY_SEMICOLON , CPC_KEY_SHIFT} ,

	   { ']'       , CPC_KEY_CLOSE_SQUARE_BRACKET , CPC_KEY_NULL } ,
	   { '}'       , CPC_KEY_CLOSE_SQUARE_BRACKET , CPC_KEY_SHIFT} ,

	   { VK_SHIFT  , CPC_KEY_SHIFT , CPC_KEY_NULL } ,

      { '/'      , CPC_KEY_BACKSLASH , CPC_KEY_NULL } ,
      { '`'      , CPC_KEY_BACKSLASH , CPC_KEY_SHIFT} ,

      { 'z'       , CPC_KEY_Z    , CPC_KEY_NULL } ,
      { 'Z'       , CPC_KEY_Z    , CPC_KEY_SHIFT} ,

      { 'x'       , CPC_KEY_X    , CPC_KEY_NULL } ,
      { 'X'       , CPC_KEY_X    , CPC_KEY_SHIFT} ,

      { 'c'       , CPC_KEY_C    , CPC_KEY_NULL } ,
      { 'C'       , CPC_KEY_C    , CPC_KEY_SHIFT} ,

      { 'v'       , CPC_KEY_V    , CPC_KEY_NULL } ,
      { 'V'       , CPC_KEY_V    , CPC_KEY_SHIFT} ,

      { 'b'       , CPC_KEY_B    , CPC_KEY_NULL } ,
      { 'B'       , CPC_KEY_B    , CPC_KEY_SHIFT} ,

      { 'n'       , CPC_KEY_N    , CPC_KEY_NULL } ,
      { 'N'       , CPC_KEY_N    , CPC_KEY_SHIFT} ,

      { 'm'       , CPC_KEY_M    , CPC_KEY_NULL } ,
      { 'M'       , CPC_KEY_M    , CPC_KEY_SHIFT} ,

      { ','       , CPC_KEY_COMMA, CPC_KEY_NULL } ,
	   { '<'       , CPC_KEY_COMMA, CPC_KEY_SHIFT} ,

      { '.'       , CPC_KEY_DOT  , CPC_KEY_NULL } ,
      { '>'       , CPC_KEY_DOT  , CPC_KEY_SHIFT} ,

      { '\\'      , CPC_KEY_FORWARD_SLASH , CPC_KEY_NULL } ,
      { '?'       , CPC_KEY_BACKSLASH, CPC_KEY_SHIFT} ,

	   { VK_SPACE  , CPC_KEY_SPACE, CPC_KEY_NULL } ,
	   { VK_CAPITAL, CPC_KEY_CAPS_LOCK , CPC_KEY_NULL } ,

/*
      { 0xBB      , CPC_KEY_MINUS , CPC_KEY_NULL } ,
      { 0xDB      , CPC_KEY_HAT  , CPC_KEY_NULL } ,
	   { 0xDD      , CPC_KEY_AT   , CPC_KEY_NULL } ,
      { 0xBA      , CPC_KEY_OPEN_SQUARE_BRACKET , CPC_KEY_NULL } ,
      { 0xC0      , CPC_KEY_COLON , CPC_KEY_NULL } ,
	   { 0xDE      , CPC_KEY_SEMICOLON , CPC_KEY_NULL } ,
	   { 0xBF      , CPC_KEY_CLOSE_SQUARE_BRACKET , CPC_KEY_NULL } ,
	   { 0xBD      , CPC_KEY_BACKSLASH , CPC_KEY_NULL } ,
	   { 0xBC      , CPC_KEY_COMMA, CPC_KEY_NULL } ,
      { 0xBE      , CPC_KEY_DOT  , CPC_KEY_NULL } ,
      { 0xE2      , CPC_KEY_FORWARD_SLASH , CPC_KEY_NULL } ,
*/
   };
   static const struct _MAP aMapNum[]=
   {
	   { VK_PRIOR  , CPC_KEY_F9   , CPC_KEY_NULL } ,
	   { VK_NEXT   , CPC_KEY_F3   , CPC_KEY_NULL } ,
      { VK_HOME   , CPC_KEY_F7   , CPC_KEY_NULL } ,
	   { VK_UP     , CPC_KEY_F8   , CPC_KEY_NULL } ,
	   { VK_LEFT   , CPC_KEY_F4   , CPC_KEY_NULL } ,
	   { VK_CLEAR  , CPC_KEY_F5   , CPC_KEY_NULL } ,
	   { VK_END    , CPC_KEY_F1   , CPC_KEY_NULL } ,
	   { VK_DOWN   , CPC_KEY_F2   , CPC_KEY_NULL } ,
	   { VK_INSERT    , CPC_KEY_F0   , CPC_KEY_NULL } ,
	   { '.'       , CPC_KEY_FDOT , CPC_KEY_NULL } ,
      { VK_RETURN , CPC_KEY_SMALL_ENTER, CPC_KEY_NULL},
	   { VK_CONTROL, CPC_KEY_CONTROL , CPC_KEY_NULL } ,
      /*
      { VK_UP     , CPC_KEY_CURSOR_UP, CPC_KEY_NULL},
      { VK_DOWN   , CPC_KEY_CURSOR_DOWN, CPC_KEY_NULL},
      { VK_LEFT   , CPC_KEY_CURSOR_LEFT, CPC_KEY_NULL},
      { VK_RIGHT  , CPC_KEY_CURSOR_RIGHT, CPC_KEY_NULL}
      */
   };

   int i;
   if (bNumPad) for (i = 0; i < _countof(aMapNum); i++)
   {
      if (aMapNum[i].vk == vk)
      {
         if (bKeyDown)
         {
            if (aMapNum[i].cpc_add != CPC_KEY_NULL)
            {
               CPC_SetKey(aMapNum[i].cpc_add);
            }
            CPC_SetKey(aMapNum[i].cpc);
         }
         else
         {
            CPC_ClearKey(aMapNum[i].cpc);
            if (aMapNum[i].cpc_add != CPC_KEY_NULL)
            {
               CPC_ClearKey(aMapNum[i].cpc_add);
            }
         }
         break;
      }
   }
   else for (i = 0; i < _countof(aMapMain); i++)
   {
      if (aMapMain[i].vk == vk)
      {
         if (bKeyDown)
         {
            if (aMapMain[i].cpc_add != CPC_KEY_NULL)
            {
               CPC_SetKey(aMapMain[i].cpc_add);
            }
            CPC_SetKey(aMapMain[i].cpc);
         }
         else
         {
            CPC_ClearKey(aMapMain[i].cpc);
            if (aMapMain[i].cpc_add != CPC_KEY_NULL)
            {
               CPC_ClearKey(aMapMain[i].cpc_add);
            }
         }
         break;
      }
   }
}

#endif

#define IDSTATUSWINDOW			1


void	MyApp_SetFullScreen(int Width, int Height)
{
	AppData.WindowedMode = FALSE;
	AppData.ScreenResX = Width;
	AppData.ScreenResY = Height;
}

void	MyApp_SetWindowed(int Width, int Height)
{
	AppData.WindowedMode = TRUE;
}


//#include "general/lnklist/lnklist.h"


//LIST_HEADER *pDialogList;
/*
void DialogList_Initialise()
{
	LinkList_InitialiseList(&pDialogList);
}
*/
/*
void DialogList_Finish()
{
	LinkList_DeleteList(&pDialogList,NULL);
}
*/
/*
void DialogList_AddDialog(HWND hDialog)
{
	LinkList_AddItemToListEnd(pDialogList, hDialog);
}
/*
/*
int	DialogList_RemoveCallback(HWND hThisDialog, HWND hDialogWanted)
{
	if (hThisDialog == hDialogWanted)
		return 0;

	return -1;
}
/*
/*
void DialogList_RemoveDialog(HWND hDialog)
{
	LIST_NODE *pDialogListNode;

	pDialogListNode = LinkList_SearchListForwards(pDialogList, hDialog, DialogList_RemoveCallback);

	if (pDialogListNode!=NULL)
	{
		LinkList_DeleteItem(pDialogList, pDialogListNode,NULL);
	}

}
*/
/*
int	DialogList_IsDialogMessageCallback(MSG *pMsg, HWND hThisDialog)
{
	if (IsDialogMessage(hThisDialog, pMsg))
		return 0;

	return -1;
}
*/
/*

BOOL DialogList_IsDialogMessage(MSG *msg)
{
	LIST_NODE *pDialogListNode = NULL;

	pDialogListNode = LinkList_SearchListForwards(pDialogList, msg, DialogList_IsDialogMessageCallback);

	if (pDialogListNode!=NULL)
		return TRUE;

	return FALSE;
}
*/

/*----------------------------------------------------------------------*/

BOOL MyApp_RegisterClass(WNDCLASSEX *pClass)
{
	// attempt to register the class
	if (RegisterClassEx(pClass)==0)
	{
		// register failed
		return FALSE;
	}

	// register succeeded
	return TRUE;
}



/*----------------------------------------------------------------------*/

#if 0
#define TOOLBAR_BUTTON_ENTRY(x,y)	{x,y,TBSTATE_ENABLED,TBSTYLE_BUTTON,0,0,0}

TBBUTTON MainWndToolbarButtons[] =
{
    TOOLBAR_BUTTON_ENTRY(0,ID_BUTTON_SET_ADDR),
    TOOLBAR_BUTTON_ENTRY(1,ID_BUTTON_DECREASE_WIDTH),
    TOOLBAR_BUTTON_ENTRY(2,ID_BUTTON_MODE0),
};

#define MAINWND_NUM_TOOLBAR_BUTTONS (sizeof(MainWndToolbarButtons)/sizeof(TBBUTTON))

#define MAINWND_TOOLBAR_BUTTON_WIDTH 28
#define MAINWND_TOOLBAR_BUTTON_HEIGHT 28

#define MAINWND_TOOLBAR_CONTROL_IDENTIFIER 3

#endif


long FAR PASCAL WindowProc( HWND hwnd, UINT iMsg, WPARAM wParam, LPARAM lParam )
{
    PAINTSTRUCT PaintStruct;

    switch(iMsg)
    {
	case WM_CREATE:

#if 0
		AppData.hwndToolbar= CreateToolbarEx(
		hwnd,
        WS_CHILD /*| WS_BORDER*/ | WS_VISIBLE,	// | CCS_TOP,
        MAINWND_TOOLBAR_CONTROL_IDENTIFIER,
        MAINWND_NUM_TOOLBAR_BUTTONS,
		AppData.AppInstance,
        IDR_TOOLBAR4,
        &MainWndToolbarButtons[0],
        MAINWND_NUM_TOOLBAR_BUTTONS,
        MAINWND_TOOLBAR_BUTTON_WIDTH,
        MAINWND_TOOLBAR_BUTTON_HEIGHT,
        MAINWND_TOOLBAR_BUTTON_WIDTH,
        MAINWND_TOOLBAR_BUTTON_HEIGHT,
        sizeof(TBBUTTON));


		AppData.hwndStatus = CreateStatusWindow(WS_CHILD | WS_VISIBLE | CCS_BOTTOM | SBARS_SIZEGRIP, _T(""), hwnd, 101);
#endif
		/* accept dropped files */
		DragAcceptFiles(hwnd, TRUE);


		return 0;

	case WM_ENDSESSION:
	{
		/* logout, reboot etc */



	}
	break;
#if 0
	// windows ce
	case WM_HIBERNATE:
	{


	}
	break;
#endif


	case WM_ACTIVATE:
	{
		if (LOWORD(wParam)!=WA_INACTIVE)
		{
			// active
			if (HIWORD(wParam)==0)
			{
				// maximized
				DI_AcquireDevices();
				DD_RestoreSurfaces();
				DD_ClearBothSurfaces();
				AppData.DoNotScanKeyboard = FALSE;

				return TRUE;
			}
		}

		CPC_ClearKeyboard();

		// maximized
		DI_UnAcquireDevices();
		AppData.DoNotScanKeyboard = TRUE;

	}
	return 0;


	case WM_ACTIVATEAPP:
	{
		BOOL	ActiveState = (BOOL)wParam;

		if (ActiveState == TRUE)
		{
			DI_AcquireDevices();
			DD_RestoreSurfaces();
			DD_ClearBothSurfaces();
			DS_StartSound();
			AppData.DoNotScanKeyboard = FALSE;
			AppData.Minimized = FALSE;
			GetWindowRect(hwnd,&AppData.WindowRectBeforeMinimize);
		}
		else
		{

			DI_UnAcquireDevices();
			//DS_StopSound();
	//		DS_ClearBuffer();
			CPC_ClearKeyboard();
			AppData.DoNotScanKeyboard = TRUE;
			AppData.Minimized = TRUE;

		}


		AppData.ApplicationIsActive = ActiveState;

	}
	return 0;
///	case WM_NOTIFY:
//	{
//		int ControlID = (int)wParam;
//		NMHDR *pNotifyHeader = (NMHDR *)lParam;
//
//	}
//	break;

//	case WM_NCLBUTTONDOWN:
//	case WM_NCMBUTTONDOWN:
//	case WM_NCRBUTTONDOWN:
	case WM_ENTERSIZEMOVE:
	case WM_ENTERMENULOOP:
	{
		DI_UnAcquireDevices();
		DS_StopSound();
		CPC_ClearKeyboard();
		AppData.DoNotScanKeyboard = TRUE;
		//DS_ClearBuffer();
	}
	break;

//	case WM_NCLBUTTONUP:
//	case WM_NCMBUTTONUP:
//	case WM_NCRBUTTONUP:
	case WM_EXITSIZEMOVE:
	case WM_EXITMENULOOP:
	{
		DI_AcquireDevices();
		DS_StartSound();
		AppData.DoNotScanKeyboard = FALSE;
	}
	break;

	
	case WM_SIZING:
		{
			
			LPRECT	pSizingRect = (LPRECT)lParam;

			if (AppData.WindowedMode)
			{
				pSizingRect->right = pSizingRect->left + AppData.WindowWidth;
				pSizingRect->bottom = pSizingRect->top + AppData.WindowHeight;
			}
			else
			{
				pSizingRect->left = 0;
				pSizingRect->right = AppData.ScreenResX;
				pSizingRect->top = 0;
				pSizingRect->bottom = AppData.ScreenResY;
			}
		}
		return 0;

//			switch (wParam)
//			{
//				case WMSZ_BOTTOM:
//					break;
//				case WMSZ_BOTTOMLEFT:
//					break;
//				case WMSZ_BOTTOMRIGHT:
//					break;
//				case WMSZ_LEFT:
//					break;
//				case WMSZ_RIGHT:
//					break;
//				case WMSZ_TOP:
//					break;
//				case WMSZ_TOPLEFT:
//					break;
//				case WMSZ_TOPRIGHT:
//					break;
//			}
//
//		}

	case WM_SIZE:
	{
#if 0
		SendMessage(AppData.hwndToolbar,WM_SIZE,wParam,lParam);
#endif


	}
	break;
#if 0
		int Width = LOWORD(lParam);
		int Height= HIWORD(lParam);
		int	ResizeFlag = wParam;

		switch (ResizeFlag)
		{
			case SIZE_MAXIMIZED:
			{
				SetWindowPos(hwnd, NULL, 0,0, WindowWidth, WindowHeight, SWP_NOMOVE | SWP_NOZORDER | SWP_NOOWNERZORDER);
			}
			return 0;

			default:
				break;
		}
	}
	break;
#endif


	case WM_PARENTNOTIFY:
	{

//		int EventFlags = LOWORD(wParam);  // event flags
//		int idChild = HIWORD(wParam);  // identifier of child window
//
//		if (EventFlags == WM_DESTROY)
//		{
//			HWND hChild = lParam;
//
//			DestroyWindow(hChild);
//		}

	}
	break;


	case WM_GETMINMAXINFO:
	{
		MINMAXINFO *pMinMax = (LPMINMAXINFO) lParam;

		if (AppData.WindowedMode)
		{
			RECT		WindowRect;

			// get current x,y position.
			GetWindowRect(hwnd, &WindowRect);

			pMinMax->ptMaxSize.x = WindowRect.right-WindowRect.left;
			pMinMax->ptMaxSize.y = WindowRect.bottom-WindowRect.top;
			pMinMax->ptMaxPosition.x = WindowRect.left;
			pMinMax->ptMaxPosition.y = WindowRect.top;
			pMinMax->ptMinTrackSize.x = AppData.WindowWidth;
			pMinMax->ptMinTrackSize.y = AppData.WindowHeight;
			pMinMax->ptMaxTrackSize.x = pMinMax->ptMaxSize.x;
			pMinMax->ptMaxTrackSize.y = pMinMax->ptMaxSize.y;

			return 0;

#if 0
			if ((WindowWidth!=0) && (WindowHeight!=0))
			{
				pMinMax->ptMaxSize.x = WindowWidth;
				pMinMax->ptMaxSize.y = WindowHeight;
				pMinMax->ptMaxPosition.x = WindowRect.left;
				pMinMax->ptMaxPosition.y = WindowRect.top;
				pMinMax->ptMinTrackSize.x = WindowWidth;
				pMinMax->ptMinTrackSize.y = WindowHeight;
				pMinMax->ptMaxTrackSize.x = WindowWidth;
				pMinMax->ptMaxTrackSize.y = WindowHeight;
				return 0;
			}
#endif
		}
		else
		{
			pMinMax->ptMaxSize.x = AppData.ScreenResX;
			pMinMax->ptMaxSize.y = AppData.ScreenResY;
			pMinMax->ptMaxPosition.x = 0;
			pMinMax->ptMaxPosition.y = 0;
			pMinMax->ptMinTrackSize.x = AppData.ScreenResX;
			pMinMax->ptMinTrackSize.y = AppData.ScreenResY;
			pMinMax->ptMaxTrackSize.x = AppData.ScreenResX;
			pMinMax->ptMaxTrackSize.y = AppData.ScreenResY;
			return 0;
		}
	}
	break;

	case WM_MOVING:
	{
		if (!AppData.WindowedMode)
		{
			LPRECT pMovingRect = (LPRECT)lParam;

			pMovingRect->left = 0;
			pMovingRect->right = AppData.ScreenResX;
			pMovingRect->top = 0;
			pMovingRect->bottom = AppData.ScreenResY;

			return TRUE;
		}
	}
	break;

	case WM_LBUTTONDOWN:
	{
		AppData.xPos = LOWORD(lParam);
		AppData.yPos = HIWORD(lParam);

		AppData.Buttons |= MK_LBUTTON;
	}
	break;

	case WM_LBUTTONUP:
	{
		AppData.Buttons &= ~MK_LBUTTON;
	}
	break;

	case WM_RBUTTONDOWN:
	{
		AppData.xPos = LOWORD(lParam);
		AppData.yPos = HIWORD(lParam);
		AppData.Buttons |= MK_RBUTTON;
	}
	break;

	case WM_RBUTTONUP:
	{
		AppData.Buttons &= ~MK_RBUTTON;
	}
	break;

	case WM_MOUSEMOVE:
	{
//		int xPos, yPos;

		AppData.xPos = LOWORD(lParam);
		AppData.yPos = HIWORD(lParam);
		AppData.Buttons = wParam;
	}
	break;

	//case WM_MOVE:

	case WM_SETFOCUS:
	{
		DI_AcquireDevices();
		AppData.DoNotScanKeyboard = FALSE;
		AppData.ApplicationHasFocus = TRUE;
		DS_StartSound();

	}
	return 0;

	case WM_KILLFOCUS:
	{
		AppData.ApplicationHasFocus = FALSE;
		DI_UnAcquireDevices();
		AppData.DoNotScanKeyboard = TRUE;
	//	DS_StopSound();

		CPC_ClearKeyboard();

/*		if (!WindowedMode)
		{
			// in full-screen and focus changed.
			// something bad might have happened

			// go to windowed mode in an attempt
			// to force a reset
			CPCEMU_SetWindowed();
		}
*/	}
	return 0;

//	case WM_SETCURSOR:

	//case WM_ENTERSIZEMOVE:
	//{
	//}
	//break;

	case WM_DROPFILES:
	{
		/* files dropped over it */

		/* drop handle */
		HDROP DropHandle = (HDROP)wParam;

        /* TODO Get shift etc pressed and use this to autostart */
		CPCEMU_HandleDragDrop(DropHandle);
	}
	return 0;

	case WM_ERASEBKGND:
		return 0;

	case WM_DISPLAYCHANGE:
	{
		if (AppData.WindowedMode)
		{
//			DD_ReleaseSurfaces();

			//DD_ShutdownWindowed();

			CPCEMU_SetWindowed();
		}
	}
	break;

    case WM_PAINT:
		
		BeginPaint( hwnd, &PaintStruct);
    //
	//	DD_FlipWindowed();
	//
		EndPaint( hwnd, &PaintStruct );
     break;
	 
	case WM_SYSCOMMAND:
    {
      switch (wParam)
      {
        case SC_SCREENSAVE:  
          return 0;
        case SC_MONITORPOWER:
          return 0;      
      } 
    }
	break;
	case WM_CLOSE:
	{
		/* quit */
		if (!CPCEMU_DoQuit(hwnd))
			return 0;

		/* allow quit to continue */
	}
	break;

    case WM_DESTROY:
	{
		/* do not accept dropped files */
		DragAcceptFiles(hwnd, FALSE);

		Interface_RemoveDisk(hwnd,0);
		Interface_RemoveDisk(hwnd,1);

        PostQuitMessage( 0 );
	}
	return 0;

	default:
		break;
	}

    return DefWindowProc(hwnd, iMsg, wParam, lParam);
}


#if 0
	/* TROELS addition if console */
  CPCHANDLE handle = (*PUB_cpc_console_api.create)(InitString, NULL);
     if (handle != NULL)
     {
        CPCEMU_MainLoop(FALSE);
        (*handle->api->close)(&handle);
     }
#endif

/*------------------------------------------------------------------------*/
/* main entry function */
int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR pCmdLine, int iCmdShow)
{

			

	/*
	#ifdef _DEBUG
	// Send all reports to STDOUT
	_CrtSetReportMode( _CRT_WARN, _CRTDBG_MODE_FILE );
    _CrtSetReportFile( _CRT_WARN, _CRTDBG_FILE_STDOUT );
    _CrtSetReportMode( _CRT_ERROR, _CRTDBG_MODE_FILE );
    _CrtSetReportFile( _CRT_ERROR, _CRTDBG_FILE_STDOUT );
    _CrtSetReportMode( _CRT_ASSERT, _CRTDBG_MODE_FILE );
    _CrtSetReportFile( _CRT_ASSERT, _CRTDBG_FILE_STDOUT );

	_CrtSetDbgFlag ( _CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF);
	_CrtSetReportMode ( _CRT_ERROR, _CRTDBG_MODE_DEBUG);
	_CrtDumpMemoryLeaks();
	#endif
	*/
#if 0
	/* does it already exist?? */
	if (GetLastError()==ERROR_ALREADY_EXISTS)
	{
		/* another instance of this application is open which has already created
		the named mutex */
		HWND hWnd;

		/* display dialog with choice of actions */
		if (MessageBox(GetDesktopWindow(),_T("Another instance of this application is open. Open this instance anyway?"),_T(APP_TITLE_TEXT),MB_ICONINFORMATION|MB_YESNO)==IDNO)
		{
			/* find the window */
			hWnd = FindWindow(_T(APP_CLASS_NAME),NULL);

			if (hWnd!=NULL)
			{
				/* window has been found */
				LPTSTR sCommandLine = GetCommandLine();

				/* if there is a command-line, communicate it to the other instance
				of this application */
				if (_tcslen(sCommandLine)!=0)
				{
					const TCHAR *sEscapedCommandLine = DDE_EscapeString(sCommandLine);

					if (sEscapedCommandLine)
					{
						DWORD ddeClientId;
						HSZ hszService;
						HSZ hszTopic;

						ddeClientId = 0;
						if (DdeInitialize(&ddeClientId,DdeClientCallback,APPCMD_CLIENTONLY,0)==DMLERR_NO_ERROR)
						{
							int iCodePage;

							/* initialise code page */
#ifndef _UNICODE
							iCodePage = CP_WINANSI;
#else
							iCodePage = CP_WINUNICODE;
#endif

							/* get handle to string */
							hszService = DdeCreateStringHandle(ddeClientId,_T(APP_NAME),iCodePage);

							if (hszService!=NULL)
							{
								/* get handle to string */
								hszTopic = DdeCreateStringHandle(ddeClientId,SZDDESYS_TOPIC,iCodePage);

								if (hszTopic!=NULL)
								{
									HCONV hConv;

									hConv = DdeConnect(ddeClientId, hszService, hszTopic,(PCONVCONTEXT)NULL);

									if (hConv!=0)
									{
										HDDEDATA hData;
										int nDataLength;

										nDataLength = (_tcslen(sEscapedCommandLine) + 2 + 10 + 1)*sizeof(TCHAR);

										hData = DdeCreateDataHandle(ddeClientId,NULL,nDataLength,0,0,CF_TEXT,0);

										if (hData)
										{
											const TCHAR *DDeKey=_T("[CmdLine \"");
											const TCHAR *DDeKeyEnd=_T("\"]");

											int nOffset = 0;
											hData = DdeAddData(hData, (LPBYTE)DDeKey, _tcslen(DDeKey),nOffset);
											nOffset+=_tcslen(DDeKey);
											hData = DdeAddData(hData, (LPBYTE)sEscapedCommandLine, _tcslen(sEscapedCommandLine), nOffset);
											nOffset+=_tcslen(sEscapedCommandLine);
											/* ensure closing null termination character */
											hData = DdeAddData(hData, (LPBYTE)DDeKeyEnd, (_tcslen(DDeKeyEnd)+sizeof(TCHAR)), nOffset);

											DdeClientTransaction((unsigned char *)hData,0x0ffffffff,hConv,0L,0,XTYP_EXECUTE,1000,NULL);

											DdeFreeDataHandle(hData);
										}

										/* disconnect the conversation */
										DdeDisconnect(hConv);
									}

									/* free handle to string */
									DdeFreeStringHandle(ddeClientId, hszTopic);
								}

								/* free handle to string */
								DdeFreeStringHandle(ddeClientId,hszService);
							}

							DdeUninitialize(ddeClientId);
						}

						/* flash the task bar */
						FlashWindow(hWnd, TRUE);

						/* free command-line string */
						free((void *)sEscapedCommandLine);
					}

				}

				/* quit */
				return FALSE;
			}
		}

	}
#endif
#if 0
#ifdef _DEBUG
	{
		/* enable memory leak checking */

		/* Get current flag */
		int tmpFlag = _CrtSetDbgFlag(_CRTDBG_REPORT_FLAG);

		/* Turn on leak-checking bit */
		tmpFlag |= _CRTDBG_LEAK_CHECK_DF;

		/* Set flag to the new value */
		_CrtSetDbgFlag(tmpFlag);
	}
#endif
#endif


	/* check to ensure this app can be started */
	if (CheckBitDepth()==FALSE)
	{
		/* show error message */
		ErrorMessage(Messages[65]);

		return 0;
	}

	/* app should be able to succeed now */

#if 0
	/* setup DDE server */
	AppData.ddeId = 0;
	if (DdeInitialize(&AppData.ddeId, DdeCallback,APPCLASS_STANDARD|CBF_SKIP_REGISTRATIONS|CBF_SKIP_CONNECT_CONFIRMS|APPCMD_FILTERINITS|CBF_FAIL_REQUESTS|CBF_SKIP_UNREGISTRATIONS,0)==DMLERR_NO_ERROR)
	{
		int iCodePage;

		/* initialise code page */
#ifndef _UNICODE
		iCodePage = CP_WINANSI;
#else
		iCodePage = CP_WINUNICODE;
#endif

		/* create a string handle identifying the server name */
		AppData.hszAppName = DdeCreateStringHandle(AppData.ddeId, _T(APP_NAME), iCodePage);

		/* create a string handle identifying the system topic */
		AppData.hszSystemTopicName = DdeCreateStringHandle(AppData.ddeId, SZDDESYS_TOPIC, iCodePage);

		if ((AppData.hszAppName!=0) && (AppData.hszSystemTopicName!=0))
		{
			/* register the server */
			DdeNameService(AppData.ddeId, AppData.hszAppName, NULL, DNS_REGISTER);
		}
	}
	else
	{
		AppData.ddeId = 0;
	}

#endif

	/* get actual command-line */
	LPSTR theCommandLine;
	theCommandLine = GetCommandLine();

	//Set defaut values, and data initialisation
	AppData.FullScreenDepth = 32; // 16 not compatible with win 10
	AppData.FullScreenWidth = 800;
	AppData.FullScreenHeight = 600;
	AppData.Windowed = true;
	RecentFiles_Init();
	RecentFiles_Restore(_T("File"));

	//Read setting from file
	GenericInterface_RestoreSettings();

	//chnage setting according to command line
	if (theCommandLine)
	{
		CPCEMU_ProcessCommandLineBefore(theCommandLine);
	}

	//Create Instance
	{
		WNDCLASSEX	WindowClass;
		BOOL bDirectX;

		InitCommonControls();

		AppData.AppInstance = hInstance;

		/* initialise class */
		WindowClass.cbSize = sizeof(WNDCLASSEX);
		WindowClass.style = CS_OWNDC;
		WindowClass.lpfnWndProc = WindowProc;
		WindowClass.cbClsExtra = 0;
		WindowClass.cbWndExtra = 0;
		WindowClass.hInstance = hInstance ? hInstance : GetModuleHandle(NULL);
		WindowClass.hIcon = LoadIcon( hInstance,MAKEINTRESOURCE(IDI_ICON_ARNOLD));
		WindowClass.hIconSm = WindowClass.hIcon;
		WindowClass.hCursor = LoadCursor( NULL, IDC_ARROW );
		WindowClass.hbrBackground = (HBRUSH)GetStockObject(BLACK_BRUSH);
		WindowClass.lpszMenuName = NULL;
		WindowClass.lpszClassName = _T(APP_CLASS_NAME);

		/* register class */
		if (MyApp_RegisterClass(&WindowClass))
		{
			/* create app window */
			AppData.ApplicationHwnd = CreateWindowEx(
				WS_EX_APPWINDOW,
				_T(APP_CLASS_NAME),
				/* the title is now static; any information should be displayed	in the status bar */
				_T(APP_NAME),
				WS_OVERLAPPEDWINDOW|WS_CLIPCHILDREN|WS_CLIPSIBLINGS ,
				0,
				0,
				GetSystemMetrics( SM_CXSCREEN ),
				GetSystemMetrics( SM_CYSCREEN ),
				NULL,
				NULL,
				hInstance,
				NULL );
			{
				LONG WindowLong;

				WindowLong = GetWindowLong(AppData.ApplicationHwnd, GWL_EXSTYLE);
				WindowLong |= WS_EX_ACCEPTFILES;
				SetWindowLong(AppData.ApplicationHwnd, GWL_EXSTYLE, WindowLong);


				WindowLong = GetWindowLong(AppData.ApplicationHwnd, GWL_STYLE);
				WindowLong &=~WS_THICKFRAME;
				SetWindowLong(AppData.ApplicationHwnd, GWL_STYLE, WindowLong);
			}

			/* show the window */
			ShowWindow( AppData.ApplicationHwnd, iCmdShow );
			/* update window */
			UpdateWindow( AppData.ApplicationHwnd );

			//Initialise directX
			bDirectX = TRUE; /*DirectX_CheckComponentsArePresent(); Checks below are safer. Troels. */

				/* check all required directx components are available */
//				if (!DirectX_CheckComponentsArePresent())
//				{
//					ErrorMessage(Messages[66]);
//				}
//				else


			bDirectX = bDirectX && DD_Init();
			if (bDirectX)
				DD_SetupDD(AppData.ApplicationHwnd,NULL);

			bDirectX = bDirectX && DI_Init(hInstance); //direct Input
			bDirectX = bDirectX && DS_Init(AppData.ApplicationHwnd); //direct sound

			if (bDirectX)
			{

				CPCEMU_Initialise();

				// Set window mode by defaut
				if (AppData.Windowed)
				{
					CPCEMU_SetWindowed();
				}
				else
				{
					if (AppData.FakeFS)
					{
						CPCEMU_SetWindowed(TRUE);
					}
					else
						{
							CPCEMU_SetFullScreen();
						}
				}

				if (theCommandLine)
				{
					CPCEMU_ProcessCommandLineAfter(theCommandLine);
				}

				DS_StartSound();

				//clear sound parasites
				//Debugsound();

				//Main loop
				CPCEMU_Run();

				CPCEMU_Finish();

				DS_Close();

				DD_CloseDD();

				DI_Close();
				DD_Close();
			}
		}
	}
#if 0
	/* free DDE stuff */
	if (AppData.ddeId!=0)
	{
		if (AppData.hszSystemTopicName!=0)
		{
			/* free the string handle */
			DdeFreeStringHandle(AppData.ddeId, AppData.hszSystemTopicName);
			AppData.hszSystemTopicName = 0;
		}

		if (AppData.hszAppName!=0)
		{
			/* unregister this server */
			DdeNameService(AppData.ddeId, AppData.hszAppName, NULL, DNS_UNREGISTER);

			/* free the string handle */
			DdeFreeStringHandle(AppData.ddeId, AppData.hszAppName);

			AppData.hszAppName = 0;
		}

		DdeUninitialize(AppData.ddeId);
	}
#endif
	RecentFiles_Store(RECENT_LIST_FILES,_T("File"));

	/* free recent items */
	RecentFiles_Free(RECENT_LIST_FILES);

#ifdef _DEBUG
	// if debug, then dump memory leaks
	//_CrtDumpMemoryLeaks();
#endif

	return 0;
}

void	SetStatusText(TCHAR *sText)
{
	SendMessage(AppData.hwndStatus, SB_SETTEXT,0, (LPARAM)sText);
}

void	MyApp_SetWindowDimensions(int Width, int Height)
{
	AppData.WindowWidth = Width;
	AppData.WindowHeight = Height;
}

typedef struct
{
	int WindowX, WindowY;
} WINDOW_SETTINGS;


void	MyApp_GetWindowSettings(WINDOW_SETTINGS *pWindowSettings)
{
	GetWindowRect(AppData.ApplicationHwnd, 0);
}


void	MyApp_CentraliseWindow(HWND hWindow, HWND hParent)
{
	RECT WindowRect;
	RECT ParentWindowRect;
	int WindowWidth, WindowHeight;
	int ParentWindowWidth, ParentWindowHeight;
	POINT WindowPos;
	HWND hParentWindow;

	if (hParent == 0)
	{
		// no parent specified, therefore centralise in desktop window
		hParentWindow = GetDesktopWindow();
	}
	else
	{
		// use specified parent
		hParentWindow = hParent;
	}


	// get window width and height.
	GetWindowRect(hWindow, &WindowRect);

	// calc width and height of this window
	WindowWidth = WindowRect.right-WindowRect.left;
	WindowHeight = WindowRect.bottom-WindowRect.top;

	// get parent window width and height.
	GetWindowRect(hParentWindow, &ParentWindowRect);

	// calc parent width and height
	ParentWindowWidth = ParentWindowRect.right - ParentWindowRect.left;
	ParentWindowHeight = ParentWindowRect.bottom - ParentWindowRect.top;

	// calc new position
	WindowPos.x = (ParentWindowWidth>>1)-(WindowWidth>>1) + ParentWindowRect.left;
	WindowPos.y = (ParentWindowHeight>>1)-(WindowHeight>>1) + ParentWindowRect.top;

	// set new pos
	SetWindowPos(hWindow, HWND_TOPMOST, WindowPos.x, WindowPos.y, WindowWidth, WindowHeight, SWP_NOSIZE | SWP_NOZORDER);
}



BOOL	WinApp_ProcessSystemEvents()
{
	MSG	Message;

	// Is a message available?
	while (PeekMessage(&Message,NULL,0,0,PM_NOREMOVE))
	{
		// yes, get the message
		if (GetMessage(&Message,NULL,0,0))
		{
			// if the message is not WM_QUIT
			// Translate it and dispatch it
			TranslateMessage(&Message);
			DispatchMessage(&Message);
		}
		else
		{
			// Message was WM_QUIT. So break out of message loop
			// and quit
			return TRUE;
		}
	}

#ifdef SHOW_TIME
	{
		char Speed[256];
		unsigned long Speed = CPCEmulation_GetPercentRelativeSpeed();

		sprintf(Speed,_T("%d%%"),Speed);

		SetStatusText(Speed);
	}
#endif
/*
	// No message, so idle, execute user function
	if (!(AppData.DoNotScanKeyboard))
	{
		DI_ScanKeyboard();
	}
*/
	return FALSE;
}


void MyApp_GetWindowRect(RECT *pRect)
{
	int Width, Height;


	if (!AppData.Minimized)
	{
		RECT WindowRect;

		/* get client rect of window */
		//GetWindowRect(AppData.ApplicationHwnd,&WindowRect);
		GetClientRect(AppData.ApplicationHwnd,&WindowRect);//EN TEST

		/* width of rectangle */
		Width = WindowRect.right-WindowRect.left;
		Height = WindowRect.bottom-WindowRect.top;

		MyApp_SetWindowDimensions(Width,Height);

		*pRect = WindowRect;

	}
	else
	{
		Width = AppData.WindowRectBeforeMinimize.right - AppData.WindowRectBeforeMinimize.left;
		Height = AppData.WindowRectBeforeMinimize.bottom - AppData.WindowRectBeforeMinimize.top;

		MyApp_SetWindowDimensions(Width, Height);

		*pRect = AppData.WindowRectBeforeMinimize;
	}
}


//****************************************************************************************************************
void GetThumbfile(char *name,int num)
{
	char tmp[MAX_PATH];
	strcpy_s(name,MAX_PATH,SnapshotPath);
	strcat(name,GetFilenameFromPathAndFilenameEXT(LastOpenedRom));
	wsprintf(tmp,"_%d",num);
	strcat(name,tmp);
	strcat(name,".bmp");
}


void ExternCommand(int command,int data)
{
	switch (command)
	{
		case 0://return
			ToogleOnScreenMenu(TRUE);
			break;
		case 1://load next disk
			{
				char name[MAX_PATH];

				if (data == 0)
				{
					SetInfoMessage("Sorry - No disk in Drive A");
					break;
				}

				strcpy_s(name,MAX_PATH,DriveAFilename);
				GetNextDisk(name,data);

				if (strcmp(LastOpenedRom,name) == 0)
				{
					SetInfoMessage("Sorry - Disk already loaded");
					break;
				}

				ToogleOnScreenMenu(TRUE);

				Interface_InsertDiskFromFile(0, name);

			}
			break;
		case 2://reset
			{
				ToogleOnScreenMenu(TRUE);
				Computer_RestartReset();
			}
			break;
		case 3://take screenshoot
			{
				char tmp[MAX_PATH];
				strcpy_s(tmp,MAX_PATH,ScreenSnapshotPath);
				strcat(tmp,GetFilenameFromPathAndFilenameEXT(LastOpenedRom));
				strcat(tmp,".bmp");
				GenericInterface_SaveScreenSnapshot(tmp,FALSE);
			}
			break;
		case 4://key simaulation
			CPC_SetKey(data);
			break;
		case 5://save snaps
			{
				char tmp[MAX_PATH];
				char name[MAX_PATH];

				if (LastOpenedRom[0] == 0)
				{
					SetInfoMessage("Sorry - No ROM loaded");
					return;
				}

				strcpy_s(name,MAX_PATH,SnapshotPath);
				strcat(name,GetFilenameFromPathAndFilenameEXT(LastOpenedRom));
				wsprintf(tmp,"_%d",data);
				strcat(name,tmp);
				strcat(name,".sna");

				//Set defaut setting for snap
				SnapshotSettings_SetSizeToExport(&Options,(SNAPSHOT_SIZE)8);
				SnapshotSettings_SetCompressed(&Options,FALSE);
				SnapshotSettings_SetVersion(&Options,3);

				if (GenericInterface_SnapshotSave(name) == FALSE)
				{
					SetInfoMessage("Sorry - Can't make snapshoot");
				}
				else
				{
					wsprintf(tmp,"Saving Snap : %s",name);
					SetInfoMessage(tmp);
					ToogleOnScreenMenu(TRUE);

					//save a thumbs
					strcpy_s(name,MAX_PATH,SnapshotPath);
					strcat(name,GetFilenameFromPathAndFilenameEXT(LastOpenedRom));
					wsprintf(tmp,"_%d",data);
					strcat(name,tmp);
					strcat(name,".bmp");
					GenericInterface_SaveScreenSnapshot(name,TRUE);
				}
			}
			break;
		case 6://load snaps
			{
				char name[MAX_PATH];
				char tmp[MAX_PATH];

				unsigned long Length;
				unsigned char *pLocation;

				SNAPSHOT_MEMORY_BLOCKS SnapshotMemoryBlocks;

				if (LastOpenedRom[0] == 0)
				{
					SetInfoMessage("Sorry - No ROM loaded");
					return;
				}

				strcpy_s(name,MAX_PATH,SnapshotPath);
				strcat(name,GetFilenameFromPathAndFilenameEXT(LastOpenedRom));
				wsprintf(tmp,"_%d",data);
				strcat(name,tmp);

				strcat(name,".sna");

				LoadFile(name, &pLocation, &Length);

				if (pLocation==NULL) {
					SetInfoMessage("Sorry - Snap Not found");
					return;
				}
				
				Snapshot_CollectMemory(&SnapshotMemoryBlocks, SnapshotSettings_GetDefault(), TRUE);
				if (Snapshot_Insert(pLocation, Length,&SnapshotMemoryBlocks)!=ARNOLD_STATUS_OK)
				{
					SetInfoMessage("Sorry,Can't load snapshoot");
				}
				else
				{
						wsprintf(tmp,"Loading Snap : %s",name);
						SetInfoMessage(tmp);
						ToogleOnScreenMenu(TRUE);
				}

				free(pLocation);
			}
			break;
		case 7://restart in other mode
			{
				ToogleOnScreenMenu(TRUE);
				if (CPCType == CPC_TYPE_6128PLUS) CPCType = CPC_TYPE_CPC6128_EN;
				else CPCType = CPC_TYPE_6128PLUS;
				CPC_SetCPCType(CPCType);
				AutoRun(AutoType_String);
			}
			break;
		case 8://cheat
			break;
		case 9://exit
			SendMessage(AppData.ApplicationHwnd, WM_CLOSE,0,0);
			break;
		default:
			break;
	}
}


static unsigned long CPC_HardwareConnectedToJoystickPort = JOYSTICK_HARDWARE_JOYSTICK;

void CPC_SetHardwareConnectedToJoystickPort(JOYSTICK_HARDWARE_ID HardwareID)
{
	CPC_HardwareConnectedToJoystickPort = HardwareID;
}

JOYSTICK_HARDWARE_ID CPC_GetHardwareConnectedToJoystickPort(void)
{
	return (JOYSTICK_HARDWARE_ID)CPC_HardwareConnectedToJoystickPort;
}


//*******************************************************************************
void DisplaySpeed(int fps)
{	
	char tmp[256];
	wsprintf(tmp,"Arnold >> Speed: %i%%",fps);
	SetWindowText(AppData.ApplicationHwnd,tmp);
}